/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.shields;

import com.google.common.collect.ImmutableList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.tools.ItemBLShield;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemWeedwoodShield
extends ItemBLShield {
    private static final ImmutableList<String> STACK_NBT_EXCLUSIONS = ImmutableList.of((Object)"burningTicks");

    public ItemWeedwoodShield() {
        super(BLMaterialRegistry.TOOL_WEEDWOOD);
        this.func_185043_a(new ResourceLocation("burning"), (stack, worldIn, entityIn) -> ((ItemWeedwoodShield)stack.func_77973_b()).getBurningTicks(stack) > 0 ? 1.0f : 0.0f);
    }

    public void setBurningTicks(ItemStack stack, int ticks) {
        stack.func_77983_a("burningTicks", (NBTBase)new NBTTagInt(ticks));
    }

    public int getBurningTicks(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("burningTicks", 3) ? tag.func_74762_e("burningTicks") : 0;
    }

    @Override
    public void onAttackBlocked(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        super.onAttackBlocked(stack, attacked, damage, source);
        if (!attacked.field_70170_p.field_72995_K && source.func_76346_g() != null) {
            Item item;
            ItemStack activeItem;
            Entity attacker = source instanceof EntityDamageSourceIndirect ? ((EntityDamageSourceIndirect)source).func_76346_g() : source.func_76346_g();
            if ((attacker.func_70027_ad() || attacker instanceof EntitySmallFireball) && attacked.field_70170_p.field_73012_v.nextFloat() < 0.5f) {
                this.setBurningTicks(stack, 80);
            } else if (attacker instanceof EntityLivingBase && attacked.field_70170_p.field_73012_v.nextFloat() < 0.25f && !(activeItem = ((EntityLivingBase)attacker).func_184607_cu()).func_190926_b() && ((item = activeItem.func_77973_b()) == ItemRegistry.OCTINE_AXE || item == ItemRegistry.OCTINE_PICKAXE || item == ItemRegistry.OCTINE_SHIELD || item == ItemRegistry.OCTINE_SHOVEL || item == ItemRegistry.OCTINE_SWORD)) {
                stack.func_77983_a("burningTicks", (NBTBase)new NBTTagInt(120));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        int burningTicks;
        if (!worldIn.field_72995_K && entityIn != null && (burningTicks = this.getBurningTicks(stack)) > 0) {
            this.setBurningTicks(stack, burningTicks - 1);
            if (burningTicks % 5 == 0) {
                worldIn.func_184148_a((EntityPlayer)null, (double)((float)entityIn.field_70165_t), (double)((float)entityIn.field_70163_u + entityIn.func_70047_e()), (double)((float)entityIn.field_70161_v), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + worldIn.field_73012_v.nextFloat(), worldIn.field_73012_v.nextFloat() * 0.7f + 0.3f);
            }
            if (burningTicks % 10 == 0 && worldIn.field_73012_v.nextFloat() < 0.3f) {
                entityIn.field_70170_p.func_72960_a(entityIn, (byte)30);
            }
            if (burningTicks % 3 == 0 && entityIn instanceof EntityLivingBase) {
                stack.func_77972_a(1, (EntityLivingBase)entityIn);
            }
            if (stack.func_190916_E() <= 0 && entityIn instanceof EntityLivingBase && entityIn instanceof EntityPlayer) {
                ((EntityPlayer)entityIn).field_71071_by.func_70299_a(itemSlot, ItemStack.field_190927_a);
                EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
                if (entityLiving.func_184592_cb() == stack) {
                    entityLiving.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        int burningTicks;
        ItemStack stack = entityItem.func_92059_d();
        if (!entityItem.field_70170_p.field_72995_K && (burningTicks = this.getBurningTicks(stack)) > 0) {
            this.setBurningTicks(stack, burningTicks - 1);
            if (burningTicks % 5 == 0) {
                entityItem.field_70170_p.func_184148_a((EntityPlayer)null, (double)((float)entityItem.field_70165_t), (double)((float)entityItem.field_70163_u + entityItem.field_70131_O / 2.0f), (double)((float)entityItem.field_70161_v), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + entityItem.field_70170_p.field_73012_v.nextFloat(), entityItem.field_70170_p.field_73012_v.nextFloat() * 0.7f + 0.3f);
            }
            if (burningTicks % 3 == 0 && stack.func_96631_a(1, entityItem.field_70170_p.field_73012_v, null)) {
                this.renderBrokenItemStack(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u + (double)(entityItem.field_70131_O / 2.0f), entityItem.field_70161_v, stack);
                stack.func_190918_g(1);
                if (stack.func_190916_E() < 0) {
                    stack.func_190920_e(0);
                }
                entityItem.func_70106_y();
            }
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean wasBurning;
        boolean bl = wasBurning = ((ItemWeedwoodShield)oldStack.func_77973_b()).getBurningTicks(oldStack) > 0;
        boolean isBurning = newStack.func_77973_b() instanceof ItemWeedwoodShield ? ((ItemWeedwoodShield)newStack.func_77973_b()).getBurningTicks(newStack) > 0 : false;
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && !isBurning || isBurning != wasBurning || !NBTHelper.areItemStackTagsEqual(oldStack, newStack, STACK_NBT_EXCLUSIONS);
    }

    protected void renderBrokenItemStack(World world, double x, double y, double z, ItemStack stack) {
        world.func_184148_a((EntityPlayer)null, x, y, z, SoundEvents.field_187635_cQ, SoundCategory.NEUTRAL, 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
        for (int i = 0; i < 5; ++i) {
            Vec3d motion = new Vec3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            world.func_175688_a(EnumParticleTypes.ITEM_CRACK, x, y, z, motion.field_72450_a, motion.field_72448_b + 0.05, motion.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b())});
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        boolean isBurning = ((ItemWeedwoodShield)itemStackIn.func_77973_b()).getBurningTicks(itemStackIn) > 0;
        return isBurning ? new ActionResult<ItemStack>(EnumActionResult.PASS, (Object)itemStackIn) : super.func_77659_a(worldIn, playerIn, hand);
    }
}

