/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.herblore.elixir.ElixirRecipes;
import thebetweenlands.common.item.ITintedItem;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemBucketInfusion
extends Item
implements ITintedItem,
ItemRegistry.IMultipleItemModelDefinition {
    public ItemBucketInfusion() {
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (this.hasTag(stack)) {
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("infused") && stack.func_77978_p().func_74764_b("ingredients") && stack.func_77978_p().func_74764_b("infusionTime")) {
                int infusionTime = stack.func_77978_p().func_74762_e("infusionTime");
                list.add(I18n.func_135052_a((String)"tooltip.bl.infusion.time", (Object[])new Object[]{StringUtils.func_76337_a((int)infusionTime), infusionTime}));
                list.add(I18n.func_135052_a((String)"tooltip.bl.infusion.ingredients", (Object[])new Object[0]));
                NBTTagList nbtList = (NBTTagList)stack.func_77978_p().func_74781_a("ingredients");
                LinkedHashMap stackMap = new LinkedHashMap();
                for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                    ItemStack ingredient = new ItemStack(nbtList.func_150305_b(i));
                    boolean contained = false;
                    for (Map.Entry stackCount : stackMap.entrySet()) {
                        if (!ItemStack.func_77989_b((ItemStack)((ItemStack)stackCount.getKey()), (ItemStack)ingredient)) continue;
                        stackMap.put(stackCount.getKey(), (Integer)stackCount.getValue() + 1);
                        contained = true;
                    }
                    if (contained) continue;
                    stackMap.put(ingredient, 1);
                }
                for (Map.Entry stackCount : stackMap.entrySet()) {
                    ItemStack ingredient = (ItemStack)stackCount.getKey();
                    int count = (Integer)stackCount.getValue();
                    if (ingredient.func_190926_b()) continue;
                    list.add((count > 1 ? count + "x " : "") + ingredient.func_82833_r());
                    ItemAspectContainer container = ItemAspectContainer.fromItem(ingredient, AspectManager.get(TheBetweenlands.proxy.getClientWorld()));
                    List<Aspect> ingredientAspects = container.getAspects(DiscoveryContainer.getMergedDiscoveryContainer((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity()));
                    if (ingredientAspects.size() < 1 || !GuiScreen.func_146272_n()) continue;
                    for (Aspect aspect : ingredientAspects) {
                        list.add("  - " + aspect.type.getName() + " (" + Aspect.ASPECT_AMOUNT_FORMAT.format(aspect.getDisplayAmount() * (float)count) + ")");
                    }
                }
            } else {
                list.add(I18n.func_135052_a((String)"tooltip.bl.infusion.empty", (Object[])new Object[0]));
            }
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player.func_70093_af()) {
            pos = pos.func_177972_a(side);
            world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            for (int i = 0; i < 50; ++i) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)pos.func_177956_o() + world.field_73012_v.nextFloat()), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
            player.func_184611_a(hand, ItemBucketInfusion.getEmptyBucket(player.func_184586_b(hand)));
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        stack.func_77982_d(new NBTTagCompound());
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    public ElixirRecipe getInfusionElixirRecipe(ItemStack stack) {
        return ElixirRecipes.getFromAspects(this.getInfusingAspects(stack));
    }

    public List<IAspectType> getInfusingAspects(ItemStack stack) {
        ArrayList<IAspectType> infusingAspects = new ArrayList<IAspectType>();
        if (this.hasTag(stack) && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("infused") && stack.func_77978_p().func_74764_b("ingredients") && stack.func_77978_p().func_74764_b("infusionTime")) {
            NBTTagList nbtList = (NBTTagList)stack.func_77978_p().func_74781_a("ingredients");
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                ItemStack ingredient = new ItemStack(nbtList.func_150305_b(i));
                ItemAspectContainer container = ItemAspectContainer.fromItem(ingredient, AspectManager.get(TheBetweenlands.proxy.getClientWorld()));
                for (Aspect aspect : container.getAspects()) {
                    infusingAspects.add(aspect.type);
                }
            }
        }
        return infusingAspects;
    }

    public int getInfusionTime(ItemStack stack) {
        if (this.hasTag(stack) && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("infused") && stack.func_77978_p().func_74764_b("ingredients") && stack.func_77978_p().func_74764_b("infusionTime")) {
            return stack.func_77978_p().func_74762_e("infusionTime");
        }
        return 0;
    }

    @Override
    public int getColorMultiplier(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            ElixirRecipe recipe = this.getInfusionElixirRecipe(stack);
            int infusionTime = this.getInfusionTime(stack);
            if (recipe != null) {
                if (infusionTime > recipe.idealInfusionTime + recipe.infusionTimeVariation) {
                    float[] failedColor = recipe.getRGBA(recipe.infusionFailedColor);
                    return this.getColorFromRGBA(failedColor[0], failedColor[1], failedColor[2], failedColor[3]);
                }
                if (infusionTime > recipe.idealInfusionTime - recipe.infusionTimeVariation && infusionTime < recipe.idealInfusionTime + recipe.infusionTimeVariation) {
                    float[] finishedColor = recipe.getRGBA(recipe.infusionFinishedColor);
                    return this.getColorFromRGBA(finishedColor[0], finishedColor[1], finishedColor[2], finishedColor[3]);
                }
                float startR = 0.2f;
                float startG = 0.6f;
                float startB = 0.4f;
                float startA = 0.9f;
                float[] targetColor = recipe.getRGBA(recipe.infusionGradient);
                int targetTime = recipe.idealInfusionTime - recipe.infusionTimeVariation;
                float infusingPercentage = (float)infusionTime / (float)targetTime;
                float interpR = startR + (targetColor[0] - startR) * infusingPercentage;
                float interpG = startG + (targetColor[1] - startG) * infusingPercentage;
                float interpB = startB + (targetColor[2] - startB) * infusingPercentage;
                float interpA = startA + (targetColor[3] - startA) * infusingPercentage;
                return this.getColorFromRGBA(interpR, interpG, interpB, interpA);
            }
            return this.getColorFromRGBA(0.8f, 0.0f, 0.8f, 1.0f);
        }
        return -1;
    }

    private int getColorFromRGBA(float r, float g, float b, float a) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public String func_77667_c(ItemStack stack) {
        try {
            switch (stack.func_77952_i()) {
                case 0: {
                    return "item.thebetweenlands.bl_bucket_infusion.weedwood";
                }
                case 1: {
                    return "item.thebetweenlands.bl_bucket_infusion.syrmorite";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "item.thebetweenlands.unknown";
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        models.put(0, new ResourceLocation(this.getRegistryName().toString() + "_weedwood"));
        models.put(1, new ResourceLocation(this.getRegistryName().toString() + "_syrmorite"));
        return models;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return ItemBucketInfusion.getEmptyBucket(itemStack);
    }

    public static ItemStack getEmptyBucket(ItemStack stack) {
        return ItemRegistry.BL_BUCKET.getEmpty(new ItemStack((Item)ItemRegistry.BL_BUCKET, 1, stack.func_77960_j()));
    }
}

