/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.common.item.tools.ItemBLBucket;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemSpecificBucket
extends ItemBLBucket {
    private static final Map<Fluid, ItemSpecificBucket> BUCKETS = new HashMap<Fluid, ItemSpecificBucket>();
    protected final FluidStack fluidStack;

    public ItemSpecificBucket(Fluid fluid) {
        super((Item)ItemRegistry.BL_BUCKET);
        this.func_77625_d(1);
        this.fluidStack = new FluidStack(fluid, 1000);
        MinecraftForge.EVENT_BUS.register((Object)this);
        BUCKETS.put(fluid, this);
    }

    public static boolean hasSpecificBucket(Fluid fluid) {
        return BUCKETS.containsKey(fluid);
    }

    @Nullable
    public static ItemSpecificBucket getSpecificBucket(Fluid fluid) {
        return BUCKETS.get(fluid);
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        return this.fluidStack.copy();
    }

    @Override
    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 2; ++i) {
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        FluidStack fluidStack;
        ItemStack emptyBucket = event.getEmptyBucket();
        if (emptyBucket.func_190926_b() || !emptyBucket.func_185136_b(this.getEmpty(emptyBucket))) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = target.func_178782_a();
        ItemStack singleBucket = emptyBucket.func_77946_l();
        singleBucket.func_190920_e(1);
        IFluidHandler targetFluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        if (targetFluidHandler != null && (fluidStack = targetFluidHandler.drain(this.fluidStack, false)) != null && fluidStack.amount == this.fluidStack.amount && fluidStack.getFluid() == this.fluidStack.getFluid()) {
            fluidStack = targetFluidHandler.drain(this.fluidStack, true);
            world.func_184133_a(null, pos, fluidStack.getFluid().getFillSound(fluidStack), SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(new ItemStack((Item)this, 1, emptyBucket.func_77960_j()));
            event.setCanceled(false);
        }
    }
}

