/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;

public class LootConditionFromSharedPool
implements LootCondition {
    private final LootCondition[] conditions;
    private final float guaranteedAfterPercentage;
    private final float guaranteedAfter;

    public LootConditionFromSharedPool(LootCondition[] conditions, float guaranteedAfterPercentage, int guaranteedAfter) {
        this.conditions = conditions;
        this.guaranteedAfterPercentage = guaranteedAfterPercentage;
        this.guaranteedAfter = guaranteedAfter;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        return !LootConditionManager.func_186638_a((LootCondition[])this.conditions, (Random)rand, (LootContext)context);
    }

    public boolean isGuaranteed(float guaranteePercentage, int guaranteeCounter) {
        return this.guaranteedAfterPercentage >= 0.0f && this.guaranteedAfterPercentage <= guaranteePercentage || this.guaranteedAfter >= 0.0f && this.guaranteedAfter <= (float)guaranteeCounter;
    }

    public static boolean isFromSharedPool(Random rand, LootContext context, List<LootCondition> conditions) {
        return LootConditionFromSharedPool.getCondition(rand, context, conditions) != null;
    }

    @Nullable
    public static LootConditionFromSharedPool getCondition(Random rand, LootContext context, List<LootCondition> conditions) {
        for (LootCondition condition : conditions) {
            if (!(condition instanceof LootConditionFromSharedPool) || !LootConditionManager.func_186638_a((LootCondition[])((LootConditionFromSharedPool)condition).conditions, (Random)rand, (LootContext)context)) continue;
            return (LootConditionFromSharedPool)condition;
        }
        return null;
    }

    public static class Serializer
    extends LootCondition.Serializer<LootConditionFromSharedPool> {
        public Serializer() {
            super(new ResourceLocation("thebetweenlands", "from_shared_pool"), LootConditionFromSharedPool.class);
        }

        public void serialize(JsonObject json, LootConditionFromSharedPool value, JsonSerializationContext context) {
            if (value.conditions.length > 0) {
                json.add("conditions", context.serialize((Object)value.conditions));
            }
        }

        public LootConditionFromSharedPool deserialize(JsonObject json, JsonDeserializationContext context) {
            LootCondition[] conditions = json.has("conditions") ? (LootCondition[])JsonUtils.func_188174_a((JsonObject)json, (String)"conditions", (JsonDeserializationContext)context, LootCondition[].class) : new LootCondition[]{};
            float guaranteedAfterPercentage = -1.0f;
            if (json.has("guaranteed_after_percentage")) {
                guaranteedAfterPercentage = JsonUtils.func_151217_k((JsonObject)json, (String)"guaranteed_after_percentage");
            }
            int guaranteedAfter = -1;
            if (json.has("guaranteed_after")) {
                guaranteedAfter = JsonUtils.func_151203_m((JsonObject)json, (String)"guaranteed_after");
            }
            return new LootConditionFromSharedPool(conditions, guaranteedAfterPercentage, guaranteedAfter);
        }
    }
}

