/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.item.misc.ItemAmateMap;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.world.storage.AmateMapData;

public class MessageAmateMap
extends MessageBase {
    private int mapId;
    private byte[] locationData;
    private SPacketMaps inner;

    public MessageAmateMap() {
    }

    public MessageAmateMap(int mapId, AmateMapData mapData, SPacketMaps inner) {
        this.mapId = mapId;
        this.locationData = mapData.serializeLocations();
        this.inner = inner;
    }

    @Override
    public void serialize(PacketBuffer buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.mapId, (int)5);
        buf.func_179250_a(this.locationData);
        try {
            this.inner.func_148840_b(buf);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write inner SPacketMaps", e);
        }
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.mapId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.locationData = buf.func_179251_a();
        this.inner = new SPacketMaps();
        try {
            this.inner.func_148837_a(buf);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read inner SPacketMaps", e);
        }
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        MapItemRenderer mapItemRenderer = Minecraft.func_71410_x().field_71460_t.func_147701_i();
        AmateMapData mapData = ItemAmateMap.loadMapData(this.mapId, (World)Minecraft.func_71410_x().field_71441_e);
        if (mapData == null) {
            MapData mapdata1;
            String s = "amatemap_" + this.mapId;
            mapData = new AmateMapData(s);
            if (mapItemRenderer.func_191205_a(s) != null && (mapdata1 = mapItemRenderer.func_191207_a(mapItemRenderer.func_191205_a(s))) instanceof AmateMapData) {
                mapData = (AmateMapData)mapdata1;
            }
            Minecraft.func_71410_x().field_71441_e.func_72823_a(s, (WorldSavedData)mapData);
        }
        this.inner.func_179734_a((MapData)mapData);
        mapData.deserializeLocations(this.locationData);
        Map vanilla = mapData.field_76203_h;
        mapData.field_76203_h = new LinkedHashMap();
        ArrayList decorations = new ArrayList(mapData.decorations.values());
        decorations.addAll(mapData.decorations.values());
        Collections.sort(decorations);
        for (AmateMapData.BLMapDecoration decor : decorations) {
            mapData.field_76203_h.put(decor.toString(), decor);
        }
        mapData.field_76203_h.putAll(vanilla);
        mapData.updateMapTexture();
    }
}

