/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.capability.circlegem.CircleGem;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.network.MessageEntity;

public class MessageGemProc
extends MessageEntity {
    private CircleGem gem;

    public MessageGemProc() {
    }

    public MessageGemProc(Entity entity, boolean offensive, CircleGemType gem) {
        this.addEntity(entity);
        this.gem = new CircleGem(gem, offensive ? CircleGem.CombatType.OFFENSIVE : CircleGem.CombatType.DEFENSIVE);
    }

    public CircleGem getGem() {
        return this.gem;
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        try {
            this.gem = CircleGem.readFromNBT(buf.func_150793_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.func_150786_a(this.gem.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public IMessage process(MessageContext ctx) {
        super.process(ctx);
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        CircleGem gem = this.getGem();
        Entity entityHit = this.getEntity(0);
        if (entityHit != null) {
            Random rnd = entityHit.field_70170_p.field_73012_v;
            for (int i = 0; i < 40; ++i) {
                double x = entityHit.field_70165_t + (double)(rnd.nextFloat() * entityHit.field_70130_N * 2.0f) - (double)entityHit.field_70130_N;
                double y = entityHit.func_174813_aQ().field_72338_b + (double)(rnd.nextFloat() * entityHit.field_70131_O);
                double z = entityHit.field_70161_v + (double)(rnd.nextFloat() * entityHit.field_70130_N * 2.0f) - (double)entityHit.field_70130_N;
                double dx = x - entityHit.field_70165_t;
                double dy = y - (entityHit.field_70163_u + (double)(entityHit.field_70131_O / 2.0f));
                double dz = z - entityHit.field_70161_v;
                double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
                ParticleFactory.ParticleArgs<?> args = ParticleFactory.ParticleArgs.get();
                switch (gem.getCombatType()) {
                    default: {
                        args.withMotion(dx / len, dy / len, dz / len);
                        break;
                    }
                    case DEFENSIVE: {
                        args.withMotion(-dx / len, -dy / len, -dz / len);
                    }
                }
                switch (gem.getGemType()) {
                    default: {
                        args.withColor(0.35f, 0.35f, 1.0f, 1.0f);
                        break;
                    }
                    case CRIMSON: {
                        args.withColor(1.0f, 0.0f, 0.0f, 1.0f);
                        break;
                    }
                    case GREEN: {
                        args.withColor(0.3f, 1.0f, 0.3f, 1.0f);
                    }
                }
                BLParticles.GEM_PROC.spawn(entityHit.field_70170_p, x, y, z, args);
            }
        }
    }
}

