/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.base.EntityCapabilityHandler;
import thebetweenlands.common.network.MessageEntity;

public class MessageSyncEntityCapabilities
extends MessageEntity {
    private ResourceLocation capability;
    private NBTTagCompound nbt;

    public MessageSyncEntityCapabilities() {
    }

    public MessageSyncEntityCapabilities(EntityCapability<?, ?, ?> entityCapability) {
        this.capability = entityCapability.getID();
        this.addEntity((Entity)entityCapability.getEntity());
        this.nbt = new NBTTagCompound();
        entityCapability.writeTrackingDataToNBT(this.nbt);
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.func_180714_a(this.capability.toString());
        buf.func_150786_a(this.nbt);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        this.capability = new ResourceLocation(buf.func_150789_c(128));
        try {
            this.nbt = buf.func_150793_b();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMessage process(MessageContext ctx) {
        super.process(ctx);
        if (ctx.side == Side.CLIENT) {
            this.handleMessage();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleMessage() {
        EntityCapability<?, ?, Entity> capability;
        Entity entity = this.getEntity(0);
        if (entity != null && (capability = EntityCapabilityHandler.getCapability(this.capability, entity)) != null) {
            capability.readTrackingDataFromNBT(this.nbt);
        }
    }
}

