/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.censer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ICenser;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.GroundFog;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.tile.TileEntityCenser;

public class CenserRecipeCremains
extends AbstractCenserRecipe<Void> {
    private static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "cremains");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return ItemMisc.EnumItemMisc.CREMAINS.isItemOf(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Void context, ICenser censer, double x, double y, double z, float partialTicks) {
        float effectStrength = censer.getEffectStrength(partialTicks);
        if (effectStrength > 0.01f && ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            float fogBrightness = 0.13f;
            float inScattering = 0.004f * effectStrength;
            float extinction = 0.15f;
            AxisAlignedBB fogArea = new AxisAlignedBB(censer.getCenserPos()).func_72314_b(6.0, 0.1, 6.0).func_72321_a(0.0, 32.0, 0.0);
            ShaderHelper.INSTANCE.getWorldShader().addGroundFogVolume(new GroundFog.GroundFogVolume(new Vec3d(fogArea.field_72340_a, fogArea.field_72338_b, fogArea.field_72339_c), new Vec3d(fogArea.field_72336_d - fogArea.field_72340_a, fogArea.field_72337_e - fogArea.field_72338_b, fogArea.field_72334_f - fogArea.field_72339_c), inScattering, extinction, fogBrightness * 0.7f, fogBrightness * 0.2f, fogBrightness * 0.1f));
        }
    }

    private List<EntityLivingBase> getAffectedEntities(World world, BlockPos pos) {
        return world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72314_b(6.0, 0.1, 6.0).func_72321_a(0.0, 12.0, 0.0));
    }

    @Override
    public int update(Void context, ICenser censer) {
        World world = censer.getCenserWorld();
        if (!world.field_72995_K && world.func_82737_E() % 10L == 0L) {
            BlockPos pos = censer.getCenserPos();
            List<EntityLivingBase> affected = this.getAffectedEntities(world, pos);
            for (EntityLivingBase living : affected) {
                if (living.func_70090_H() || living.func_180431_b(DamageSource.field_76372_a) || living.func_70045_F() || living instanceof EntityPlayer && ((EntityPlayer)living).func_184812_l_()) continue;
                living.func_70015_d(1);
            }
        }
        return 0;
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        boolean isDeathFromCenser = false;
        if (entity != null && entity.func_70027_ad() && event.getSource().func_76347_k()) {
            int sx = MathHelper.func_76128_c((double)(entity.field_70165_t - 6.0)) >> 4;
            int sz = MathHelper.func_76128_c((double)(entity.field_70161_v - 6.0)) >> 4;
            int ex = MathHelper.func_76128_c((double)(entity.field_70165_t + 6.0)) >> 4;
            int ez = MathHelper.func_76128_c((double)(entity.field_70161_v + 6.0)) >> 4;
            block0: for (int cx = sx; cx <= ex; ++cx) {
                for (int cz = sz; cz <= ez; ++cz) {
                    Chunk chunk = entity.field_70170_p.func_72964_e(cx, cz);
                    for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                        TileEntityCenser censer;
                        TileEntity tile = (TileEntity)entry.getValue();
                        if (!(tile instanceof TileEntityCenser) || !(censer = (TileEntityCenser)tile).isRecipeRunning() || !(censer.getCurrentRecipe() instanceof CenserRecipeCremains)) continue;
                        isDeathFromCenser = true;
                        break block0;
                    }
                }
            }
        }
        if (isDeathFromCenser) {
            Iterator dropsIT = event.getDrops().iterator();
            while (dropsIT.hasNext()) {
                dropsIT.next();
                if (!entity.field_70170_p.field_73012_v.nextBoolean()) continue;
                dropsIT.remove();
            }
            int cremains = entity.field_70170_p.field_73012_v.nextInt(3);
            for (int i = 0; i < cremains; ++i) {
                event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, ItemMisc.EnumItemMisc.CREMAINS.create(1)));
            }
        }
    }

    @Override
    public int getConsumptionDuration(Void context, ICenser censer) {
        return 3;
    }

    @Override
    public int getEffectColor(Void context, ICenser censer, ICenserRecipe.EffectColorType type) {
        return -11534336;
    }
}

