/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.censer;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ICenser;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.common.herblore.elixir.effects.ElixirEffect;
import thebetweenlands.common.item.herblore.ItemElixir;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.recipe.censer.CenserRecipeElixirContext;
import thebetweenlands.common.registries.ItemRegistry;

public class CenserRecipeElixir
extends AbstractCenserRecipe<CenserRecipeElixirContext> {
    private static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "elixir");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        if (stack.func_77973_b() == ItemRegistry.ELIXIR) {
            ElixirEffect effect = ItemRegistry.ELIXIR.getElixirFromItem(stack);
            return !effect.getPotionEffect().func_76403_b();
        }
        return false;
    }

    @Override
    public CenserRecipeElixirContext createContext(ItemStack stack) {
        return new CenserRecipeElixirContext(stack);
    }

    private List<EntityLivingBase> getAffectedEntities(World world, BlockPos pos, CenserRecipeElixirContext context) {
        int amplifier = ItemRegistry.ELIXIR.createPotionEffect(context.elixir, 1.0).func_76458_c();
        int xzRange = 35 + amplifier * 15;
        int yRange = 12 + amplifier * 4;
        return world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72314_b((double)xzRange, 1.0, (double)xzRange).func_72321_a(0.0, (double)yRange, 0.0));
    }

    @Override
    public int update(CenserRecipeElixirContext context, ICenser censer) {
        World world = censer.getCenserWorld();
        if (world.func_82737_E() % 100L == 0L) {
            ElixirEffect.ElixirPotionEffect potion = ItemRegistry.ELIXIR.getElixirFromItem(context.elixir).getPotionEffect();
            int maxDuration = ItemRegistry.ELIXIR.createPotionEffect(context.elixir, 0.25).func_76459_b();
            BlockPos pos = censer.getCenserPos();
            List<EntityLivingBase> affected = this.getAffectedEntities(world, pos, context);
            if (!world.field_72995_K) {
                for (EntityLivingBase living : affected) {
                    living.func_70690_d(new PotionEffect((Potion)potion, Math.min(maxDuration, 300), 0, true, false));
                }
            }
            context.setConsuming(!affected.isEmpty());
        }
        return 0;
    }

    private int getEffectiveDuration(CenserRecipeElixirContext context) {
        PotionEffect effect = ItemRegistry.ELIXIR.createPotionEffect(context.elixir, 1.0);
        return 20 + effect.func_76459_b() * 8;
    }

    @Override
    public int getConsumptionDuration(CenserRecipeElixirContext context, ICenser censer) {
        return Math.max(1, MathHelper.func_76141_d((float)((float)this.getEffectiveDuration(context) / 1000.0f)));
    }

    @Override
    public int getConsumptionAmount(CenserRecipeElixirContext context, ICenser censer) {
        if (!context.isConsuming()) {
            return 0;
        }
        return 1 + MathHelper.func_76141_d((float)(1000.0f / (float)this.getEffectiveDuration(context)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getEffectColor(CenserRecipeElixirContext context, ICenser censer, ICenserRecipe.EffectColorType type) {
        return ((ItemElixir)context.elixir.func_77973_b()).getColorMultiplier(context.elixir, 0);
    }
}

