/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.recipes.ICompostBinRecipe;
import thebetweenlands.common.recipe.custom.CustomRecipes;
import thebetweenlands.common.recipe.misc.CompostRecipe;

public class CustomCompostBinRecipes
extends CustomRecipes<ICompostBinRecipe> {
    public CustomCompostBinRecipes() {
        super("compost_bin", (Map<String, CustomRecipes.RecipeArg<?>>)ImmutableMap.of((Object)"input/item", CustomRecipes.RecipeArg.ITEM_INPUT, (Object)"input/composting_time", CustomRecipes.RecipeArg.INT, (Object)"output", CustomRecipes.RecipeArg.INT), (Map<String, CustomRecipes.RecipeArg<?>>)ImmutableMap.of());
    }

    @Override
    public ICompostBinRecipe load() {
        ItemStack input = (ItemStack)((CustomRecipes.IRecipeEntry)this.get("input/item", CustomRecipes.RecipeArg.ITEM_INPUT).get()).create();
        int compostingTime = (Integer)((CustomRecipes.IRecipeEntry)this.get("input/composting_time", CustomRecipes.RecipeArg.INT).get()).create();
        int compostAmount = (Integer)((CustomRecipes.IRecipeEntry)this.get("output", CustomRecipes.RecipeArg.INT).get()).create();
        return new CompostRecipe(compostAmount, compostingTime, input);
    }

    @Override
    public CustomRecipes.IRecipeRegistrar<ICompostBinRecipe> createRegistrar() {
        return new CustomRecipes.IRecipeRegistrar<ICompostBinRecipe>(){

            @Override
            public boolean register(ICompostBinRecipe recipe) {
                CompostRecipe.addRecipe(recipe);
                return true;
            }

            @Override
            public boolean unregister(ICompostBinRecipe recipe) {
                CompostRecipe.removeRecipe(recipe);
                return true;
            }
        };
    }
}

