/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;
import thebetweenlands.api.recipes.ICompostBinRecipe;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.CompostRecipe;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityCompostBin
extends TileEntityBasicInventory
implements ITickable {
    public static final int COMPOST_PER_ITEM = 25;
    public static final int MAX_COMPOST_AMOUNT = 400;
    public static final int MAX_ITEMS = 20;
    public static final float MAX_OPEN = 90.0f;
    public static final float MIN_OPEN = 0.0f;
    public static final float OPEN_SPEED = 10.0f;
    public static final float CLOSE_SPEED = 10.0f;
    private int compostedAmount;
    private int totalCompostAmount;
    private boolean open = false;
    private float lidAngle = 0.0f;
    private int[] processes = new int[20];
    private int[] compostAmounts = new int[20];
    private int[] compostTimes = new int[20];

    public TileEntityCompostBin() {
        super("container.bl.compost_bin", (NonNullList<ItemStack>)NonNullList.func_191197_a((int)20, (Object)ItemStack.field_190927_a), (te, inv) -> new ItemStackHandler((NonNullList)inv, (TileEntityBasicInventory)((Object)te)){
            final /* synthetic */ TileEntityBasicInventory val$te;
            {
                this.val$te = tileEntityBasicInventory;
                super(x0);
            }

            public void setSize(int size) {
                this.stacks = this.val$te.inventory = NonNullList.func_191197_a((int)20, (Object)ItemStack.field_190927_a);
            }

            protected void onContentsChanged(int slot) {
                if (this.val$te.func_145830_o()) {
                    this.val$te.func_70296_d();
                }
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        });
    }

    public static int[] readIntArrayFixedSize(String id, int length, NBTTagCompound compound) {
        int[] array = compound.func_74759_k(id);
        return array.length != length ? new int[length] : array;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void func_73660_a() {
        float f = this.lidAngle = this.open ? Math.min(this.lidAngle + 10.0f, 90.0f) : Math.max(this.lidAngle - 10.0f, 0.0f);
        if (!this.field_145850_b.field_72995_K) {
            int i;
            if (!this.open) {
                for (i = 0; i < this.inventory.size(); ++i) {
                    if (this.func_70301_a(i).func_190926_b()) continue;
                    if (this.processes[i] >= this.compostTimes[i]) {
                        this.compostedAmount += this.compostAmounts[i];
                        super.func_70299_a(i, ItemStack.field_190927_a);
                        this.processes[i] = 0;
                        this.compostTimes[i] = 0;
                        this.compostAmounts[i] = 0;
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                        continue;
                    }
                    int n = i;
                    this.processes[n] = this.processes[n] + 1;
                }
            }
            for (i = 1; i < this.inventory.size(); ++i) {
                if (!this.func_70301_a(i - 1).func_190926_b() || this.func_70301_a(i).func_190926_b()) continue;
                this.func_70299_a(i - 1, this.func_70301_a(i));
                this.func_70299_a(i, ItemStack.field_190927_a);
                this.processes[i - 1] = this.processes[i];
                this.processes[i] = 0;
                this.compostAmounts[i - 1] = this.compostAmounts[i];
                this.compostAmounts[i] = 0;
                this.compostTimes[i - 1] = this.compostTimes[i];
                this.compostTimes[i] = 0;
            }
        }
    }

    public boolean removeCompost(int amount) {
        if (this.compostedAmount != 0) {
            if (this.compostedAmount >= amount) {
                this.compostedAmount -= amount;
                this.totalCompostAmount -= amount;
            } else {
                this.compostedAmount = 0;
                this.totalCompostAmount = 0;
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int addItemToBin(ItemStack stack, int compostAmount, int compostTime, boolean doSimulate) {
        int clampedAmount;
        int n = clampedAmount = this.getTotalCompostAmount() + compostAmount <= 400 ? compostAmount : 400 - this.getTotalCompostAmount();
        if (clampedAmount > 0) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (!this.func_70301_a(i).func_190926_b()) continue;
                if (!doSimulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(1);
                    super.func_70299_a(i, copy);
                    this.compostAmounts[i] = clampedAmount;
                    this.compostTimes[i] = compostTime;
                    this.processes[i] = 0;
                    this.totalCompostAmount += clampedAmount;
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                }
                return 1;
            }
            return 0;
        }
        return -1;
    }

    private boolean canAddItemToBin(int compostAmount, int index) {
        return ((ItemStack)this.inventory.get(index)).func_190926_b() && (this.getTotalCompostAmount() + compostAmount <= 400 ? compostAmount : 400 - this.getTotalCompostAmount()) > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        if (nbt.func_150297_b("Items", 11)) {
            nbt.func_74783_a("Inventory", nbt.func_74759_k("Items"));
        }
        super.func_145839_a(nbt);
        this.processes = TileEntityCompostBin.readIntArrayFixedSize("Processes", this.inventory.size(), nbt);
        this.compostAmounts = TileEntityCompostBin.readIntArrayFixedSize("CompostAmounts", this.inventory.size(), nbt);
        this.compostTimes = TileEntityCompostBin.readIntArrayFixedSize("CompostTimes", this.inventory.size(), nbt);
        this.totalCompostAmount = nbt.func_74762_e("TotalCompostAmount");
        this.compostedAmount = nbt.func_74762_e("CompostedAmount");
        this.open = nbt.func_74767_n("Open");
        this.lidAngle = nbt.func_74760_g("LidAngle");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74783_a("Processes", this.processes);
        nbt.func_74783_a("CompostAmounts", this.compostAmounts);
        nbt.func_74783_a("CompostTimes", this.compostTimes);
        nbt.func_74768_a("TotalCompostAmount", this.totalCompostAmount);
        nbt.func_74768_a("CompostedAmount", this.compostedAmount);
        nbt.func_74757_a("Open", this.open);
        nbt.func_74776_a("LidAngle", this.lidAngle);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public float getLidAngle(float partialTicks) {
        return this.open ? Math.min(this.lidAngle + 10.0f * partialTicks, 90.0f) : Math.max(this.lidAngle - 10.0f * partialTicks, 0.0f);
    }

    public int getTotalCompostAmount() {
        return this.totalCompostAmount;
    }

    public int getCompostedAmount() {
        return this.compostedAmount;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            int[] slots = new int[20];
            for (int i = 0; i < 20; ++i) {
                slots[i] = i;
            }
            return slots;
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{this.inventory.size() + 1};
        }
        return new int[0];
    }

    @Override
    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, EnumFacing direction) {
        ICompostBinRecipe recipe = CompostRecipe.getCompostRecipe(itemStackIn);
        return recipe != null && this.open && !itemStackIn.func_190926_b() && direction == EnumFacing.UP && this.canAddItemToBin(recipe.getCompostAmount(itemStackIn), index);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return this.open && ItemMisc.EnumItemMisc.COMPOST.isItemOf(stack) && direction == EnumFacing.DOWN;
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.size();
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    @MethodsReturnNonnullByDefault
    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.func_70302_i_()) {
            return super.func_70301_a(index);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @MethodsReturnNonnullByDefault
    public ItemStack func_70298_a(int index, int count) {
        if (index < this.inventory.size() && !this.func_70301_a(index).func_190926_b()) {
            if (this.func_70301_a(index).func_190916_E() <= count) {
                this.processes[index] = 0;
                this.compostTimes[index] = 0;
                this.totalCompostAmount -= this.compostAmounts[index];
                this.compostAmounts[index] = 0;
                return super.func_70298_a(index, count);
            }
            ItemStack itemstack = this.func_70301_a(index).func_77979_a(count);
            if (this.func_70301_a(index).func_190916_E() == 0) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @MethodsReturnNonnullByDefault
    public ItemStack func_70304_b(int index) {
        if (!((ItemStack)this.inventory.get(index)).func_190926_b()) {
            this.processes[index] = 0;
            this.compostTimes[index] = 0;
            this.totalCompostAmount -= this.compostAmounts[index];
            this.compostAmounts[index] = 0;
            return super.func_70304_b(index);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70299_a(int index, @Nullable ItemStack stack) {
        ICompostBinRecipe recipe;
        if (index < 20 && (recipe = CompostRecipe.getCompostRecipe(stack)) != null) {
            this.addItemToBin(stack, recipe.getCompostAmount(stack), recipe.getCompostingTime(stack), false);
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        ICompostBinRecipe recipe = CompostRecipe.getCompostRecipe(stack);
        return recipe != null && this.canAddItemToBin(recipe.getCompostAmount(stack), index);
    }
}

