/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.common.block.structure.BlockDungeonDoorRunes;
import thebetweenlands.common.entity.mobs.EntityBarrishee;
import thebetweenlands.common.entity.mobs.EntityCryptCrawler;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.gen.feature.structure.LightTowerBuildParts;

public class TileEntityDungeonDoorRunes
extends TileEntity
implements ITickable,
IEntityScreenShake {
    private LightTowerBuildParts lightTowerBuild = new LightTowerBuildParts(null);
    private boolean mimic;
    private boolean barrishee;
    public int top_code = -1;
    public int mid_code = -1;
    public int bottom_code = -1;
    public int top_state = 0;
    public int mid_state = 0;
    public int bottom_state = 0;
    public int top_state_prev = 0;
    public int mid_state_prev = 0;
    public int bottom_state_prev = 0;
    public int top_rotate = 0;
    public int mid_rotate = 0;
    public int bottom_rotate = 0;
    public int lastTickTopRotate = 0;
    public int lastTickMidRotate = 0;
    public int lastTickBottomRotate = 0;
    public int renderTicks = 0;
    public boolean animate_open = false;
    public boolean animate_open_recess = false;
    public boolean animate_tile_recess = false;
    public boolean break_blocks = false;
    public int slate_1_rotate = 0;
    public int slate_2_rotate = 0;
    public int slate_3_rotate = 0;
    public int last_tick_slate_1_rotate = 0;
    public int last_tick_slate_2_rotate = 0;
    public int last_tick_slate_3_rotate = 0;
    public int recess_pos = 0;
    public int last_tick_recess_pos = 0;
    public int tile_1_recess_pos = 0;
    public int last_tick_recess_pos_tile_1 = 0;
    public int tile_2_recess_pos = 0;
    public int last_tick_recess_pos_tile_2 = 0;
    public int tile_3_recess_pos = 0;
    public int last_tick_recess_pos_tile_3 = 0;
    private int prev_shake_timer;
    private int shake_timer;
    private boolean shaking = false;
    private boolean falling_shake = false;
    public boolean hide_slate_1 = false;
    public boolean hide_slate_2 = false;
    public boolean hide_slate_3 = false;
    public boolean hide_lock = false;
    public boolean hide_back_wall = false;
    public boolean is_in_dungeon = false;
    public boolean is_gate_entrance = false;
    private final ItemStack renderStack = new ItemStack(BlockRegistry.MUD_TOWER_BEAM_RELAY.func_176223_P().func_177230_c());
    private int shakingTimerMax = 240;

    public TileEntityDungeonDoorRunes(boolean mimic, boolean barishee) {
        this.mimic = mimic;
        this.barrishee = barishee;
    }

    public TileEntityDungeonDoorRunes() {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(1.0);
    }

    public void sinkingParticles(float ySpikeVel) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDungeonDoorRunes.FACING);
        if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
            for (int z = -1; z <= 1; ++z) {
                if (!this.func_145831_w().field_72995_K) continue;
                this.spawnSinkingParticles(this.func_174877_v().func_177982_a(0, -1, z), 0.0f + ySpikeVel);
            }
        }
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            for (int x = -1; x <= 1; ++x) {
                if (!this.func_145831_w().field_72995_K) continue;
                this.spawnSinkingParticles(this.func_174877_v().func_177982_a(x, -1, 0), 0.0f + ySpikeVel);
            }
        }
    }

    public void crashingParticles(float ySpikeVel) {
        int z;
        int x;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDungeonDoorRunes.FACING);
        AxisAlignedBB hitBox = new AxisAlignedBB(this.func_174877_v().func_177967_a(facing, 2)).func_186662_g(1.0);
        if (facing == EnumFacing.EAST) {
            for (x = 1; x <= 3; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (!this.func_145831_w().field_72995_K) continue;
                    this.spawnCrashingParticles(this.func_174877_v().func_177982_a(x, -1, z), 0.0f + ySpikeVel);
                }
            }
        }
        if (facing == EnumFacing.WEST) {
            for (x = -1; x >= -3; --x) {
                for (z = -1; z <= 1; ++z) {
                    if (!this.func_145831_w().field_72995_K) continue;
                    this.spawnCrashingParticles(this.func_174877_v().func_177982_a(x, -1, z), 0.0f + ySpikeVel);
                }
            }
        }
        if (facing == EnumFacing.SOUTH) {
            for (x = -1; x <= 1; ++x) {
                for (z = 1; z <= 3; ++z) {
                    if (!this.func_145831_w().field_72995_K) continue;
                    this.spawnCrashingParticles(this.func_174877_v().func_177982_a(x, -1, z), 0.0f + ySpikeVel);
                }
            }
        }
        if (facing == EnumFacing.NORTH) {
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z >= -3; --z) {
                    if (!this.func_145831_w().field_72995_K) continue;
                    this.spawnCrashingParticles(this.func_174877_v().func_177982_a(x, -1, z), 0.0f + ySpikeVel);
                }
            }
        }
        List list = this.func_145831_w().func_72872_a(EntityLivingBase.class, hitBox);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityBarrishee || this.func_145831_w().field_72995_K) continue;
            entity.func_70097_a(DamageSource.field_82729_p, 10.0f);
        }
    }

    private void spawnSinkingParticles(BlockPos pos, float ySpikeVel) {
        if (this.func_145831_w().field_72995_K) {
            double px = (double)pos.func_177958_n() + 0.5;
            double py = (double)pos.func_177956_o() + 0.0625;
            double pz = (double)pos.func_177952_p() + 0.5;
            int amount = 2 + this.func_145831_w().field_73012_v.nextInt(2);
            for (int i = 0; i < amount; ++i) {
                double ox = this.func_145831_w().field_73012_v.nextDouble() * (double)0.1f - (double)0.05f;
                double oz = this.func_145831_w().field_73012_v.nextDouble() * (double)0.1f - (double)0.05f;
                double motionX = this.func_145831_w().field_73012_v.nextDouble() * (double)0.2f - (double)0.1f;
                double motionY = this.func_145831_w().field_73012_v.nextDouble() * (double)0.1f + (double)0.075f + (double)ySpikeVel;
                double motionZ = this.func_145831_w().field_73012_v.nextDouble() * (double)0.2f - (double)0.1f;
                this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)BlockRegistry.MUD_TILES.func_176223_P())});
            }
        }
    }

    private void spawnCrashingParticles(BlockPos pos, float ySpikeVel) {
        if (this.func_145831_w().field_72995_K) {
            double px = (double)pos.func_177958_n() + 0.5;
            double py = (double)pos.func_177956_o() + 0.0625;
            double pz = (double)pos.func_177952_p() + 0.5;
            int amount = 2 + this.func_145831_w().field_73012_v.nextInt(2);
            for (int i = 0; i < amount; ++i) {
                double ox = this.func_145831_w().field_73012_v.nextDouble() * (double)0.1f - (double)0.05f;
                double oz = this.func_145831_w().field_73012_v.nextDouble() * (double)0.1f - (double)0.05f;
                double motionX = this.func_145831_w().field_73012_v.nextDouble() * (double)0.2f - (double)0.1f;
                double motionY = this.func_145831_w().field_73012_v.nextDouble() * (double)0.025f + (double)0.075f;
                double motionZ = this.func_145831_w().field_73012_v.nextDouble() * (double)0.2f - (double)0.1f;
                this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox, py, pz + oz, motionX, motionY + (double)ySpikeVel, motionZ, new int[]{Block.func_176210_f((IBlockState)BlockRegistry.MUD_BRICKS.func_176223_P())});
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px + ox, py, pz + oz, motionX, 0.0, motionZ, new int[0]);
            }
        }
    }

    public void func_73660_a() {
        EnumFacing facing;
        int limit;
        ++this.renderTicks;
        this.lastTickTopRotate = this.top_rotate;
        this.lastTickMidRotate = this.mid_rotate;
        this.lastTickBottomRotate = this.bottom_rotate;
        this.last_tick_slate_1_rotate = this.slate_1_rotate;
        this.last_tick_slate_2_rotate = this.slate_2_rotate;
        this.last_tick_slate_3_rotate = this.slate_3_rotate;
        this.last_tick_recess_pos = this.recess_pos;
        this.last_tick_recess_pos_tile_1 = this.tile_1_recess_pos;
        this.last_tick_recess_pos_tile_2 = this.tile_2_recess_pos;
        this.last_tick_recess_pos_tile_3 = this.tile_3_recess_pos;
        if (this.top_state_prev != this.top_state) {
            this.top_rotate += 4;
            if (this.top_rotate > 90) {
                this.top_rotate = 0;
                this.lastTickTopRotate = 0;
                this.top_state_prev = this.top_state;
            }
        }
        if (this.mid_state_prev != this.mid_state) {
            this.mid_rotate += 4;
            if (this.mid_rotate > 90) {
                this.mid_rotate = 0;
                this.lastTickMidRotate = 0;
                this.mid_state_prev = this.mid_state;
            }
        }
        if (this.bottom_state_prev != this.bottom_state) {
            this.bottom_rotate += 4;
            if (this.bottom_rotate > 90) {
                this.bottom_rotate = 0;
                this.lastTickBottomRotate = 0;
                this.bottom_state_prev = this.bottom_state;
            }
        }
        if (this.animate_open_recess) {
            if (this.recess_pos <= 0 && !this.func_145831_w().field_72995_K) {
                this.playOpenRecessSound(true);
            }
            this.shake(240);
            ++this.recess_pos;
            limit = 30;
            if (this.recess_pos > limit) {
                this.last_tick_recess_pos = this.recess_pos = limit;
                if (!this.func_145831_w().field_72995_K) {
                    this.animate_open_recess = false;
                    if (!this.animate_open) {
                        this.animate_open = true;
                        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                    }
                }
            }
        }
        if (this.animate_tile_recess) {
            if (!this.mimic) {
                if (this.tile_1_recess_pos <= 0 && !this.func_145831_w().field_72995_K) {
                    this.playOpenRecessSound(false);
                }
                if (this.tile_2_recess_pos == 2 && !this.func_145831_w().field_72995_K) {
                    this.playOpenRecessSound(false);
                }
                if (this.tile_3_recess_pos == 2 && !this.func_145831_w().field_72995_K) {
                    this.playOpenRecessSound(false);
                }
                this.tile_1_recess_pos += 2;
                if (this.tile_1_recess_pos >= 20) {
                    this.tile_2_recess_pos += 2;
                }
                if (this.tile_2_recess_pos >= 20) {
                    this.tile_3_recess_pos += 2;
                }
            }
            if (this.tile_1_recess_pos >= (limit = 60)) {
                this.last_tick_recess_pos_tile_1 = this.tile_1_recess_pos = limit;
            }
            if (this.tile_2_recess_pos >= limit) {
                this.last_tick_recess_pos_tile_2 = this.tile_2_recess_pos = limit;
            }
            if (this.tile_3_recess_pos >= limit) {
                this.last_tick_recess_pos_tile_3 = this.tile_3_recess_pos = limit;
                if (!this.func_145831_w().field_72995_K) {
                    this.break_blocks = true;
                    this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                }
            }
        }
        if (this.animate_open) {
            if (this.mimic) {
                if (this.slate_1_rotate <= 0 && !this.func_145831_w().field_72995_K) {
                    this.playTrapFallingSound();
                    IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                    facing = (EnumFacing)state.func_177229_b((IProperty)BlockDungeonDoorRunes.FACING);
                    BlockPos offsetPos = this.func_174877_v().func_177972_a(facing.func_176734_d());
                    if (this.barrishee) {
                        EntityBarrishee entity = new EntityBarrishee(this.func_145831_w());
                        entity.func_70012_b((double)offsetPos.func_177958_n() + 0.5, offsetPos.func_177977_b().func_177956_o(), (double)offsetPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                        entity.field_70759_as = entity.field_70177_z;
                        entity.field_70761_aq = entity.field_70177_z;
                        entity.setIsAmbushSpawn(true);
                        entity.setIsScreaming(true);
                        entity.setScreamTimer(0);
                        this.func_145831_w().func_72838_d((Entity)entity);
                    } else {
                        EntityCryptCrawler entity = new EntityCryptCrawler(this.func_145831_w());
                        entity.func_70012_b((double)offsetPos.func_177958_n() + 0.5, offsetPos.func_177977_b().func_177956_o(), (double)offsetPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                        entity.field_70759_as = entity.field_70177_z;
                        entity.field_70761_aq = entity.field_70177_z;
                        entity.setIsBiped(true);
                        entity.setIsChief(true);
                        entity.func_180482_a(this.func_145831_w().func_175649_E(this.func_174877_v()), null);
                        this.func_145831_w().func_72838_d((Entity)entity);
                    }
                }
                this.slate_1_rotate += 4 + (this.last_tick_slate_1_rotate < 8 ? 0 : this.last_tick_slate_1_rotate / 8);
                this.slate_2_rotate += 2 + (this.last_tick_slate_2_rotate < 6 ? 0 : this.last_tick_slate_2_rotate / 6);
                this.slate_3_rotate += 2 + (this.last_tick_slate_3_rotate < 8 ? 0 : this.last_tick_slate_3_rotate / 8);
                this.hide_lock = true;
                this.hide_back_wall = true;
            }
            if (!this.mimic) {
                if (this.slate_1_rotate == 0 && !this.func_145831_w().field_72995_K) {
                    this.playOpenSinkingSound();
                    if (this.is_gate_entrance) {
                        this.lightTowerBuild.destroyGateBeamLenses(this.func_145831_w(), this.func_174877_v());
                        this.lightTowerBuild.destroyTowerBeamLenses(this.func_145831_w(), this.func_174877_v().func_177982_a(-15, -2, -14));
                    }
                }
                this.slate_1_rotate += 4;
                this.slate_2_rotate += 3;
                this.slate_3_rotate += 3;
            }
            int n = limit = this.mimic ? 90 : 360;
            if (!this.mimic) {
                if (this.slate_3_rotate < limit - 6) {
                    this.sinkingParticles(0.0f);
                } else {
                    this.sinkingParticles(0.25f);
                }
            }
            if (this.slate_1_rotate >= limit) {
                if (this.mimic) {
                    this.falling_shake = true;
                    this.crashingParticles(0.125f);
                    this.hide_slate_1 = true;
                }
                this.last_tick_slate_1_rotate = this.slate_1_rotate = limit;
            }
            if (this.slate_2_rotate >= limit) {
                if (this.mimic) {
                    this.crashingParticles(0.125f);
                    this.hide_slate_2 = true;
                }
                this.last_tick_slate_2_rotate = this.slate_2_rotate = limit;
            }
            if (this.slate_3_rotate >= limit) {
                if (this.mimic) {
                    this.crashingParticles(0.125f);
                    this.hide_slate_3 = true;
                }
                if (!this.mimic) {
                    this.hide_slate_1 = true;
                    this.hide_slate_2 = true;
                    this.hide_slate_3 = true;
                    this.hide_lock = true;
                    this.hide_back_wall = true;
                }
                this.last_tick_slate_3_rotate = this.slate_3_rotate = limit;
                if (!this.func_145831_w().field_72995_K) {
                    if (this.mimic) {
                        this.break_blocks = true;
                    }
                    if (!this.mimic) {
                        if (this.is_in_dungeon) {
                            this.animate_tile_recess = true;
                        } else {
                            this.break_blocks = true;
                        }
                    }
                    this.animate_open = false;
                    this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                }
            }
            if (this.falling_shake) {
                this.shake(10);
                this.falling_shake = this.shaking;
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            facing = (EnumFacing)state.func_177229_b((IProperty)BlockDungeonDoorRunes.FACING);
            if (this.top_state_prev == this.top_code && this.mid_state_prev == this.mid_code && this.bottom_state_prev == this.bottom_code) {
                if (!this.mimic) {
                    if (!this.animate_open_recess) {
                        this.animate_open_recess = true;
                        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                    }
                } else if (!this.animate_open) {
                    this.animate_open = true;
                    this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                }
            }
            if (this.break_blocks) {
                if (!this.mimic) {
                    if (this.is_in_dungeon) {
                        this.breakAllDoorBlocks(state, facing, true, false);
                    } else {
                        this.breakAllDoorBlocks(state, facing, false, false);
                    }
                } else {
                    this.breakAllDoorBlocks(state, facing, false, false);
                }
            }
            if (this.func_145831_w().func_82737_E() % 5L == 0L) {
                this.checkComplete(state, facing);
            }
        }
    }

    public void shake(int shakeTimerMax) {
        this.shakingTimerMax = shakeTimerMax;
        this.prev_shake_timer = this.shake_timer;
        if (this.shake_timer == 0) {
            this.shaking = true;
            this.shake_timer = 1;
        }
        if (this.shake_timer > 0) {
            ++this.shake_timer;
        }
        this.shaking = this.shake_timer < this.shakingTimerMax;
    }

    private void checkComplete(IBlockState state, EnumFacing facing) {
        int y;
        if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
            for (int z = -1; z <= 1; ++z) {
                for (y = -1; y <= 1; ++y) {
                    if (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(0, y, z)).func_177230_c() instanceof BlockDungeonDoorRunes) continue;
                    this.breakAllDoorBlocks(state, facing, false, true);
                }
            }
        }
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            for (int x = -1; x <= 1; ++x) {
                for (y = -1; y <= 1; ++y) {
                    if (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(x, y, 0)).func_177230_c() instanceof BlockDungeonDoorRunes) continue;
                    this.breakAllDoorBlocks(state, facing, false, true);
                }
            }
        }
    }

    public void breakAllDoorBlocks(IBlockState state, EnumFacing facing, boolean breakFloorBelow, boolean particles) {
        int y;
        if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
            for (int z = -1; z <= 1; ++z) {
                int n = y = breakFloorBelow ? -2 : -1;
                while (y <= 1) {
                    if (particles) {
                        this.func_145831_w().func_175655_b(this.func_174877_v().func_177982_a(0, y, z), false);
                        this.func_145831_w().func_175713_t(this.func_174877_v());
                    } else {
                        this.func_145831_w().func_180501_a(this.func_174877_v().func_177982_a(0, y, z), Blocks.field_150350_a.func_176223_P(), 3);
                        this.func_145831_w().func_175713_t(this.func_174877_v());
                    }
                    ++y;
                }
            }
        }
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            for (int x = -1; x <= 1; ++x) {
                int n = y = breakFloorBelow ? -2 : -1;
                while (y <= 1) {
                    if (particles) {
                        this.func_145831_w().func_175655_b(this.func_174877_v().func_177982_a(x, y, 0), false);
                        this.func_145831_w().func_175713_t(this.func_174877_v());
                    } else {
                        this.func_145831_w().func_180501_a(this.func_174877_v().func_177982_a(x, y, 0), Blocks.field_150350_a.func_176223_P(), 3);
                        this.func_145831_w().func_175713_t(this.func_174877_v());
                    }
                    ++y;
                }
            }
        }
    }

    public void cycleTopState() {
        this.top_state_prev = this.top_state++;
        if (this.top_state > 7) {
            this.top_state = 0;
        }
        this.func_70296_d();
        this.playLockSound();
    }

    public void cycleMidState() {
        this.mid_state_prev = this.mid_state++;
        if (this.mid_state > 7) {
            this.mid_state = 0;
        }
        this.func_70296_d();
        this.playLockSound();
    }

    public void cycleBottomState() {
        this.bottom_state_prev = this.bottom_state++;
        if (this.bottom_state > 7) {
            this.bottom_state = 0;
        }
        this.func_70296_d();
        this.playLockSound();
    }

    public void enterLockCode() {
        this.top_code = this.top_state;
        this.mid_code = this.mid_state;
        this.bottom_code = this.bottom_state;
        this.top_state = 0;
        this.top_state_prev = 0;
        this.mid_state = 0;
        this.mid_state_prev = 0;
        this.bottom_state = 0;
        this.bottom_state_prev = 0;
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.func_70296_d();
    }

    private void playLockSound() {
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.MUD_DOOR_LOCK, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private void playOpenRecessSound(boolean isBigDoor) {
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.MUD_DOOR_1, SoundCategory.BLOCKS, isBigDoor ? 1.0f : 0.5f, 1.0f);
    }

    private void playOpenSinkingSound() {
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.MUD_DOOR_2, SoundCategory.BLOCKS, 1.0f, 0.9f);
    }

    private void playTrapFallingSound() {
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.MUD_DOOR_TRAP, SoundCategory.BLOCKS, 1.0f, 1.25f);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.top_code = nbt.func_74762_e("top_code");
        this.mid_code = nbt.func_74762_e("mid_code");
        this.bottom_code = nbt.func_74762_e("bottom_code");
        this.top_state = nbt.func_74762_e("top_state");
        this.mid_state = nbt.func_74762_e("mid_state");
        this.bottom_state = nbt.func_74762_e("bottom_state");
        this.top_state_prev = nbt.func_74762_e("top_state_prev");
        this.mid_state_prev = nbt.func_74762_e("mid_state_prev");
        this.bottom_state_prev = nbt.func_74762_e("bottom_state_prev");
        this.mimic = nbt.func_74767_n("mimic");
        this.barrishee = nbt.func_74767_n("barrishee");
        this.animate_open = nbt.func_74767_n("animate_open");
        this.animate_open_recess = nbt.func_74767_n("animate_open_recess");
        this.animate_tile_recess = nbt.func_74767_n("animate_tile_recess");
        this.break_blocks = nbt.func_74767_n("break_blocks");
        this.hide_slate_1 = nbt.func_74767_n("hide_slate_1");
        this.hide_slate_2 = nbt.func_74767_n("hide_slate_2");
        this.hide_slate_3 = nbt.func_74767_n("hide_slate_3");
        this.hide_lock = nbt.func_74767_n("hide_lock");
        this.hide_back_wall = nbt.func_74767_n("hide_back_wall");
        this.is_in_dungeon = nbt.func_74767_n("is_in_dungeon");
        this.is_gate_entrance = nbt.func_74767_n("is_gate_entrance");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("top_code", this.top_code);
        nbt.func_74768_a("mid_code", this.mid_code);
        nbt.func_74768_a("bottom_code", this.bottom_code);
        nbt.func_74768_a("top_state", this.top_state);
        nbt.func_74768_a("mid_state", this.mid_state);
        nbt.func_74768_a("bottom_state", this.bottom_state);
        nbt.func_74768_a("top_state_prev", this.top_state_prev);
        nbt.func_74768_a("mid_state_prev", this.mid_state_prev);
        nbt.func_74768_a("bottom_state_prev", this.bottom_state_prev);
        nbt.func_74757_a("mimic", this.mimic);
        nbt.func_74757_a("barrishee", this.barrishee);
        nbt.func_74757_a("animate_open", this.animate_open);
        nbt.func_74757_a("animate_open_recess", this.animate_open_recess);
        nbt.func_74757_a("animate_tile_recess", this.animate_tile_recess);
        nbt.func_74757_a("break_blocks", this.break_blocks);
        nbt.func_74757_a("hide_slate_1", this.hide_slate_1);
        nbt.func_74757_a("hide_slate_2", this.hide_slate_2);
        nbt.func_74757_a("hide_slate_3", this.hide_slate_3);
        nbt.func_74757_a("hide_lock", this.hide_lock);
        nbt.func_74757_a("hide_back_wall", this.hide_back_wall);
        nbt.func_74757_a("is_in_dungeon", this.is_in_dungeon);
        nbt.func_74757_a("is_gate_entrance", this.is_gate_entrance);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.isShaking()) {
            double dist = this.getDistance(viewer);
            float shakeMult = (float)(1.0 - dist / 10.0);
            if (dist >= 10.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.getShakingProgress(partialTicks) * Math.PI) + (double)0.1f) * (double)0.075f * (double)shakeMult);
        }
        return 0.0f;
    }

    public float getDistance(Entity entity) {
        float distX = this.func_174877_v().func_177958_n() - entity.func_180425_c().func_177958_n();
        float distY = this.func_174877_v().func_177956_o() - entity.func_180425_c().func_177956_o();
        float distZ = this.func_174877_v().func_177952_p() - entity.func_180425_c().func_177952_p();
        return MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
    }

    public boolean isShaking() {
        return this.shaking;
    }

    public float getShakingProgress(float delta) {
        return 1.0f / (float)this.shakingTimerMax * ((float)this.prev_shake_timer + (float)(this.shake_timer - this.prev_shake_timer) * delta);
    }

    public boolean isMimic() {
        return this.mimic;
    }

    public ItemStack cachedStack() {
        return this.renderStack;
    }
}

