/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Random;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.common.network.datamanager.GenericDataManager;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.EventRift;
import thebetweenlands.common.world.event.EventSnowfall;
import thebetweenlands.common.world.event.EventWinter;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventAuroras
extends TimedEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "auroras");
    protected static final DataParameter<Integer> AURORA_TYPE = GenericDataManager.createKey(EventAuroras.class, DataSerializers.field_187192_b);

    public EventAuroras(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    protected void initDataParameters() {
        super.initDataParameters();
        this.dataManager.register(AURORA_TYPE, 0);
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(8000) + 28000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(5000) + 8000;
    }

    @Override
    public void setActive(boolean active) {
        if (active && this.canBeActive() || !active) {
            super.setActive(active);
            if (active && !this.getWorld().field_72995_K) {
                this.dataManager.set(AURORA_TYPE, this.getWorld().field_73012_v.nextInt(3));
            }
        }
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!world.field_72995_K && !this.canBeActive() && this.getTicks() > 500) {
            this.dataManager.set(TICKS, 500).syncImmediately();
        }
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        this.getData().func_74777_a("auroraType", this.getAuroraType());
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        this.dataManager.set(AURORA_TYPE, Integer.valueOf(this.getData().func_74765_d("auroraType")));
    }

    public short getAuroraType() {
        return (short)this.dataManager.get(AURORA_TYPE).intValue();
    }

    protected boolean canBeActive() {
        for (IEnvironmentEvent event : this.getRegistry().getEventsOfState(true)) {
            if (event == this || event.getClass() == EventWinter.class || event.getClass() == EventSnowfall.class || event.getClass() == EventRift.class) continue;
            return false;
        }
        return true;
    }
}

