/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.entity.EntityBLLightningBolt;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventThunderstorm
extends TimedEnvironmentEvent {
    protected int updateLCG = new Random().nextInt();
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "thunderstorm");

    public EventThunderstorm(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    protected boolean canActivate() {
        return this.getRegistry().heavyRain.isActive();
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!world.field_72995_K) {
            if (this.isActive() && !this.getRegistry().heavyRain.isActive()) {
                this.setActive(false);
            }
            if (this.isActive() && world.field_73011_w instanceof WorldProviderBetweenlands && world instanceof WorldServer) {
                WorldServer worldServer = (WorldServer)world;
                Iterator iterator = worldServer.getPersistentChunkIterable(worldServer.func_184164_w().func_187300_b());
                while (iterator.hasNext()) {
                    Chunk chunk = (Chunk)iterator.next();
                    if (!world.field_73011_w.canDoLightning(chunk) || world.field_73012_v.nextInt(2500) != 0) continue;
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int l = this.updateLCG >> 2;
                    BlockPos seedPos = new BlockPos(chunk.field_76635_g * 16 + (l & 0xF), 0, chunk.field_76647_h * 16 + (l >> 8 & 0xF));
                    boolean isFlyingPlayerTarget = false;
                    BlockPos pos = this.getNearbyFlyingPlayer(worldServer, seedPos);
                    if (pos == null) {
                        pos = this.adjustPosToNearbyEntity(worldServer, seedPos);
                    } else {
                        isFlyingPlayerTarget = true;
                    }
                    if (pos.func_177956_o() <= 150 && this.getWorld().field_73012_v.nextInt(8) != 0 || !world.func_175727_C(pos)) continue;
                    world.func_72838_d((Entity)new EntityBLLightningBolt(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), isFlyingPlayerTarget ? 50 : 400, isFlyingPlayerTarget));
                }
            }
        }
    }

    @Nullable
    protected BlockPos getNearbyFlyingPlayer(WorldServer world, BlockPos blockpos) {
        EntityPlayer closestPlayer = null;
        double closestDistSq = Double.MAX_VALUE;
        for (EntityPlayer player : world.field_73010_i) {
            double dstSq;
            if (!(player.field_70163_u > 130.0) || player.field_70122_E && !player.func_184218_aH()) continue;
            BlockPos blockPos = new BlockPos((Entity)player);
            if (!(player.field_70163_u - (double)world.func_175645_m(blockPos).func_177956_o() > 8.0) || !((dstSq = ((double)blockpos.func_177958_n() - player.field_70165_t) * ((double)blockpos.func_177958_n() - player.field_70165_t) + ((double)blockpos.func_177952_p() - player.field_70161_v) * ((double)blockpos.func_177952_p() - player.field_70161_v)) < closestDistSq)) continue;
            closestPlayer = player;
            closestDistSq = dstSq;
        }
        if (closestPlayer != null && closestDistSq < 2500.0) {
            double motionZ;
            double motionY;
            double motionX;
            if (closestPlayer.func_184187_bx() != null) {
                motionX = closestPlayer.func_184187_bx().field_70159_w;
                motionY = closestPlayer.func_184187_bx().field_70181_x;
                motionZ = closestPlayer.func_184187_bx().field_70179_y;
            } else {
                motionX = closestPlayer.field_70159_w;
                motionY = closestPlayer.field_70181_x;
                motionZ = closestPlayer.field_70179_y;
            }
            return new BlockPos(closestPlayer).func_177963_a(motionX * 60.0 + (double)world.field_73012_v.nextInt(5) - 2.0, motionY * 60.0 + (double)world.field_73012_v.nextInt(5) - 2.0, motionZ * 60.0 + (double)world.field_73012_v.nextInt(5) - 2.0);
        }
        return null;
    }

    protected BlockPos adjustPosToNearbyEntity(final WorldServer world, BlockPos pos) {
        BlockPos blockpos = world.func_175725_q(pos);
        AxisAlignedBB aabb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.func_177958_n(), world.func_72800_K(), blockpos.func_177952_p())).func_186662_g(3.0);
        List list = world.func_175647_a(EntityLivingBase.class, aabb, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase entity) {
                return entity != null && entity.func_70089_S() && world.func_175678_i(entity.func_180425_c());
            }
        });
        if (!list.isEmpty()) {
            return ((EntityLivingBase)list.get(world.field_73012_v.nextInt(list.size()))).func_180425_c();
        }
        if (blockpos.func_177956_o() == -1) {
            blockpos = blockpos.func_177981_b(2);
        }
        return blockpos;
    }

    @Override
    public int getOffTime(Random rnd) {
        return 5000 + rnd.nextInt(4000);
    }

    @Override
    public int getOnTime(Random rnd) {
        return 4000 + rnd.nextInt(4000);
    }
}

