/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class FlatLandFeature
extends BiomeFeature {
    private final int waterHeight;
    private final int terrainOffset;
    private NoiseGeneratorPerlin landNoiseGen;
    private double[] landNoise = new double[256];
    private NoiseGeneratorPerlin riverNoiseGen;
    private double[] riverNoise = new double[256];

    public FlatLandFeature(int waterHeight, int terrainOffset) {
        this.waterHeight = waterHeight;
        this.terrainOffset = terrainOffset;
    }

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        Random rng = new Random(seed);
        this.landNoiseGen = new NoiseGeneratorPerlin(rng, 4);
        this.riverNoiseGen = new NoiseGeneratorPerlin(rng, 2);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.landNoise = this.landNoiseGen.func_151599_a(this.landNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.06, 0.06, 1.0);
        this.riverNoise = this.riverNoiseGen.func_151599_a(this.riverNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.032, 0.032, 1.0);
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        block5: {
            if (pass != BiomeGenerator.EnumGeneratorPass.PRE_REPLACE_BIOME_BLOCKS) break block5;
            float biomeWeight = biomeWeights.get(x, z, 0.0f, 10.0f);
            int lowestBlock = 0;
            for (int yOff = 0; yOff < this.waterHeight; ++yOff) {
                int y = this.waterHeight - yOff;
                Block currentBlock = chunkPrimer.func_177856_a(x, y, z).func_177230_c();
                if (currentBlock == chunkGenerator.layerBlock || currentBlock == Blocks.field_150350_a) continue;
                lowestBlock = y;
                break;
            }
            double noise = this.landNoise[x * 16 + z] / 18.0;
            double riverNoise = Math.abs(this.riverNoise[x * 16 + z]) * 4.0;
            riverNoise *= riverNoise * riverNoise * riverNoise * riverNoise;
            int terrainHeight = (int)Math.ceil(Math.abs(noise * (double)(this.waterHeight - lowestBlock + this.terrainOffset)));
            float riverThreshold = 6.0f * (float)(terrainHeight + 2);
            double riverPercentage = 1.0 - (riverNoise *= 25.0) / (double)riverThreshold;
            float weight = (Math.min(biomeWeight + 0.5f, 1.0f) - 0.5f) * 2.0f;
            if (riverNoise < (double)riverThreshold) {
                int y = lowestBlock;
                while ((double)y < FlatLandFeature.lerp((double)(this.waterHeight + terrainHeight) - riverPercentage * ((double)terrainHeight + ((double)riverThreshold - riverNoise) / 16.0), lowestBlock, weight)) {
                    chunkPrimer.func_177855_a(x, y, z, chunkGenerator.baseBlockState);
                    ++y;
                }
            } else {
                int y = lowestBlock;
                while ((double)y < FlatLandFeature.lerp(this.waterHeight + terrainHeight, lowestBlock, weight)) {
                    chunkPrimer.func_177855_a(x, y, z, chunkGenerator.baseBlockState);
                    ++y;
                }
            }
        }
    }
}

