/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.structure.BlockWaystone;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class WorldGenWaystone
extends WorldGenerator
implements IWorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (SurfaceType.MIXED_GROUND.matches(world.func_180495_p(pos.func_177977_b()))) {
            IBlockState state1 = world.func_180495_p(pos);
            IBlockState state2 = world.func_180495_p(pos.func_177984_a());
            IBlockState state3 = world.func_180495_p(pos.func_177981_b(2));
            if (!state1.func_185904_a().func_76224_d() && state1.func_177230_c().func_176200_f((IBlockAccess)world, pos) && !state2.func_185904_a().func_76224_d() && state2.func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a()) && !state3.func_185904_a().func_76224_d() && state3.func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177981_b(2))) {
                IBlockState state = BlockRegistry.WAYSTONE.func_176223_P();
                world.func_175656_a(pos, state.func_177226_a(BlockWaystone.PART, (Comparable)((Object)BlockWaystone.Part.BOTTOM)));
                world.func_175656_a(pos.func_177981_b(2), state.func_177226_a(BlockWaystone.PART, (Comparable)((Object)BlockWaystone.Part.TOP)));
                world.func_175656_a(pos.func_177981_b(1), state.func_177226_a(BlockWaystone.PART, (Comparable)((Object)BlockWaystone.Part.MIDDLE)));
                BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
                AxisAlignedBB locationAABB = new AxisAlignedBB(pos.func_177984_a()).func_72314_b(4.0, 3.0, 4.0);
                LocationStorage locationStorage = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos.func_177958_n(), pos.func_177952_p()), "waystone", EnumLocationType.WAYSTONE);
                locationStorage.setSeed(rand.nextLong());
                locationStorage.addBounds(locationAABB);
                locationStorage.setVisible(false);
                locationStorage.setDirty(true);
                worldStorage.getLocalStorageHandler().addLocalStorage(locationStorage);
            }
        }
        return false;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
            int gridSizePower2 = 3;
            int gridBlockSize = 1 << gridSizePower2 + 4;
            int regionX = chunkX >> gridSizePower2;
            int regionZ = chunkZ >> gridSizePower2;
            long regionSeed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L ^ world.func_72905_C();
            regionSeed = regionSeed * regionSeed * 42317861L + regionSeed * 11L;
            Random seededRandom = new Random(regionSeed);
            int blockX = (regionX << gridSizePower2 + 4) + gridBlockSize / 4 + seededRandom.nextInt(gridBlockSize / 2 + 1);
            int blockZ = (regionZ << gridSizePower2 + 4) + gridBlockSize / 4 + seededRandom.nextInt(gridBlockSize / 2 + 1);
            if (blockX > chunkX * 16 + 5 && blockZ > chunkZ * 16 + 5 && blockX < (chunkX + 2) * 16 - 5 && blockZ < (chunkZ + 2) * 16 - 5) {
                int height = world.func_189649_b(blockX, blockZ);
                this.func_180709_b(world, random, new BlockPos(blockX, height, blockZ));
            }
        }
    }
}

