/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFace;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFaceLarge;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFaceSmall;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.feature.tree.WorldGenSpiritTree;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationSpiritTree;
import thebetweenlands.util.BlockShapeUtils;

public class WorldGenSpiritTreeStructure
extends WorldGenerator {
    public static final int RADIUS_INNER_CIRLCE = 6;
    public static final int RADIUS_OUTER_CIRCLE = 14;
    private static final ThreadLocal<Boolean> CASCADING_GEN_MUTEX = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public WorldGenSpiritTreeStructure() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        if (CASCADING_GEN_MUTEX.get().booleanValue()) {
            return false;
        }
        CASCADING_GEN_MUTEX.set(true);
        try {
            BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
            LocationSpiritTree location = new LocationSpiritTree(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(position));
            location.addBounds(new AxisAlignedBB(new BlockPos((Vec3i)position)).func_72314_b(32.0, 16.0, 32.0).func_72317_d(0.0, 6.0, 0.0));
            location.setLayer(0);
            location.setSeed(rand.nextLong());
            location.setVisible(true);
            WorldGenSpiritTree genSpiritTree = new WorldGenSpiritTree(location.getGuard(), location);
            if (genSpiritTree.func_180709_b(world, rand, position)) {
                BlockPos root;
                double bz;
                double bx;
                double dz;
                double dx;
                double dir;
                int i;
                this.generateWispCircle(world, rand, position, 6, 1, 2, location);
                this.generateWispCircle(world, rand, position, 14, 1, 1, location);
                int rootsGenerated = 0;
                for (i = 0; i < 80; ++i) {
                    dir = rand.nextDouble() * Math.PI * 2.0;
                    dx = Math.cos(dir);
                    dz = Math.sin(dir);
                    bx = dx * 16.0 + dx * rand.nextDouble() * 16.0;
                    bz = dz * 16.0 + dz * rand.nextDouble() * 16.0;
                    root = position.func_177963_a(bx, 0.0, bz);
                    if ((root = this.findGroundPosition(world, root)) == null || !world.func_175623_d(root) || !world.func_175623_d(root.func_177984_a())) continue;
                    this.generateRoot(world, rand, root, genSpiritTree, location);
                    if (rootsGenerated++ > 12) break;
                }
                for (i = 0; i < 120; ++i) {
                    dir = rand.nextDouble() * Math.PI * 2.0;
                    dx = Math.cos(dir);
                    dz = Math.sin(dir);
                    bx = dx * 16.0 + dx * rand.nextDouble() * 16.0;
                    bz = dz * 16.0 + dz * rand.nextDouble() * 16.0;
                    root = position.func_177963_a(bx, 0.0, bz);
                    if ((root = this.findGroundPosition(world, root)) == null || !world.func_175623_d(root) || !world.func_175623_d(root.func_177984_a())) continue;
                    int height = 2 + rand.nextInt(4);
                    for (int yo = 0; yo < height; ++yo) {
                        this.setBlock(world, root.func_177981_b(yo), BlockRegistry.ROOT.func_176223_P(), location);
                    }
                }
                this.trySpawnFace(world, rand, new EntitySpiritTreeFaceLarge(world), location.getLargeFacePositions());
                for (i = 0; i < 8; ++i) {
                    this.trySpawnFace(world, rand, new EntitySpiritTreeFaceSmall(world), location.getSmallFacePositions());
                }
                location.setDirty(true);
                worldStorage.getLocalStorageHandler().addLocalStorage(location);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            CASCADING_GEN_MUTEX.set(false);
        }
    }

    private void trySpawnFace(World world, Random rand, EntitySpiritTreeFace face, List<BlockPos> locations) {
        BlockPos faceAnchor = null;
        EnumFacing faceFacing = null;
        ArrayList<BlockPos> largeFacePositions = new ArrayList<BlockPos>();
        largeFacePositions.addAll(locations);
        Collections.shuffle(largeFacePositions, rand);
        block0: for (BlockPos anchor : largeFacePositions) {
            ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
            facings.addAll(Arrays.asList(EnumFacing.field_176754_o));
            Collections.shuffle(facings, rand);
            for (EnumFacing facing : facings) {
                if (face.checkAnchorAt(anchor, facing, EnumFacing.UP, 7) != 0) continue;
                faceAnchor = anchor;
                faceFacing = facing;
                break block0;
            }
        }
        if (faceAnchor != null && faceFacing != null) {
            face.func_180482_a(world.func_175649_E(faceAnchor), null);
            face.setPositionToAnchor(faceAnchor, faceFacing, EnumFacing.UP);
            world.func_72838_d((Entity)face);
        }
    }

    @Nullable
    private BlockPos findGroundPosition(World world, BlockPos pos) {
        boolean hadAir = false;
        for (int yo = 6; yo >= -6; --yo) {
            BlockPos offsetPos = pos.func_177981_b(yo);
            IBlockState state = world.func_180495_p(offsetPos);
            if (hadAir && SurfaceType.MIXED_GROUND.test(state)) {
                return offsetPos.func_177984_a();
            }
            if (!state.func_177230_c().isAir(state, (IBlockAccess)world, offsetPos)) continue;
            hadAir = true;
        }
        return null;
    }

    private void generateWispCircle(World world, Random rand, BlockPos center, int radius, int minHeight, int heightVar, LocationSpiritTree location) {
        List<BlockPos> circle = BlockShapeUtils.getCircle(center, radius, new ArrayList<BlockPos>());
        for (int i = 0; i < circle.size() && i != circle.size() - 1; i += 2 + rand.nextInt(2)) {
            BlockPos pos = circle.get(i);
            if ((pos = this.findGroundPosition(world, pos)) == null || !world.func_175623_d(pos) && !(world.func_180495_p(pos).func_177230_c() instanceof IPlantable)) continue;
            BlockPos wall = pos.func_177977_b();
            this.setBlock(world, wall, BlockRegistry.MOSSY_BETWEENSTONE_BRICKS.func_176223_P(), location);
            int height = minHeight + rand.nextInt(heightVar + 1);
            for (int yo = 0; yo < height; ++yo) {
                wall = pos.func_177981_b(yo);
                this.setBlock(world, wall, BlockRegistry.MOSSY_BETWEENSTONE_BRICK_WALL.func_176223_P(), location);
            }
            BlockPos wisp = pos.func_177981_b(height);
            if (rand.nextInt(4) == 0) {
                this.setBlock(world, wisp, BlockRegistry.WISP.func_176223_P(), location);
                location.addGeneratedWispPosition(wisp);
                continue;
            }
            location.addNotGeneratedWispPosition(wisp);
        }
    }

    private void generateRoot(World world, Random rand, BlockPos pos, WorldGenSpiritTree tree, LocationSpiritTree location) {
        List<BlockPos> potentialBlocks = tree.generateBranchPositions(rand, pos, rand.nextInt(7), 32, 0.4, 0.3, (i, remainingBlocks) -> i < 2 ? 1 : (i > 4 ? -1 : 0), (i, length) -> true);
        int length2 = 0;
        for (int i2 = 0; i2 < potentialBlocks.size(); ++i2) {
            BlockPos block = potentialBlocks.get(i2);
            if (i2 <= 2 || world.func_175623_d(block)) continue;
            length2 = i2 + 1;
            break;
        }
        BlockPos prevPos = null;
        for (int i3 = 0; i3 < length2; ++i3) {
            BlockPos block = potentialBlocks.get(i3);
            if (prevPos != null) {
                int xo = block.func_177958_n() - prevPos.func_177958_n();
                int yo = block.func_177956_o() - prevPos.func_177956_o();
                int zo = block.func_177952_p() - prevPos.func_177952_p();
                int moves = Math.abs(xo) + Math.abs(yo) + Math.abs(zo);
                if (moves > 1) {
                    ArrayList<BlockPos> choices = new ArrayList<BlockPos>();
                    if (xo != 0) {
                        choices.add(new BlockPos(xo, 0, 0));
                    }
                    if (yo != 0) {
                        choices.add(new BlockPos(0, yo, 0));
                    }
                    if (zo != 0) {
                        choices.add(new BlockPos(0, 0, zo));
                    }
                    BlockPos filler = prevPos;
                    for (int j = 0; j < moves; ++j) {
                        filler = filler.func_177971_a((Vec3i)choices.remove(rand.nextInt(choices.size())));
                        this.setBlock(world, filler, BlockRegistry.LOG_SPIRIT_TREE.func_176223_P(), location);
                    }
                }
            }
            this.setBlock(world, block, BlockRegistry.LOG_SPIRIT_TREE.func_176223_P(), location);
            prevPos = block;
        }
    }

    protected void setBlock(World world, BlockPos pos, IBlockState state, LocationSpiritTree location) {
        this.func_175903_a(world, pos, state);
        if (state.func_177230_c() != BlockRegistry.WISP) {
            location.getGuard().setGuarded(world, pos, true);
        }
        if (state.func_177230_c() == BlockRegistry.LOG_SPIRIT_TREE) {
            location.addSmallFacePosition(pos);
        }
    }
}

