/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;
import thebetweenlands.common.TheBetweenlands;

public class LocalStorageSaveHandler
implements IThreadedFileIO {
    private static final NBTTagCompound DELETE_NBT = new NBTTagCompound();
    private final ConcurrentHashMap<File, NBTTagCompound> filesToSave = new ConcurrentHashMap();
    private final Set<File> fileLocks = new HashSet<File>();

    public boolean queueRegion(File regionFile, @Nullable NBTTagCompound regionNbtCopy) {
        this.filesToSave.put(regionFile, regionNbtCopy == null ? DELETE_NBT : regionNbtCopy);
        ThreadedFileIOBase.func_178779_a().func_75735_a((IThreadedFileIO)this);
        return true;
    }

    public boolean queueLocalStorage(File storageFile, @Nullable NBTTagCompound storageNbtCopy) {
        this.filesToSave.put(storageFile, storageNbtCopy == null ? DELETE_NBT : storageNbtCopy);
        ThreadedFileIOBase.func_178779_a().func_75735_a((IThreadedFileIO)this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockFile(File file) throws InterruptedException {
        Set<File> set = this.fileLocks;
        synchronized (set) {
            while (this.fileLocks.contains(file)) {
                this.fileLocks.wait();
            }
            this.fileLocks.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockFile(File file) {
        Set<File> set = this.fileLocks;
        synchronized (set) {
            this.fileLocks.remove(file);
            this.fileLocks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NBTTagCompound loadFileNbt(File file) throws IOException {
        NBTTagCompound queuedNbt = this.filesToSave.get(file);
        if (queuedNbt != null) {
            return queuedNbt.func_74737_b();
        }
        this.lockFile(file);
        try {
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74797_a((File)file);
            this.unlockFile(file);
            return nBTTagCompound;
        }
        catch (Throwable throwable) {
            try {
                this.unlockFile(file);
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_75814_c() {
        if (!this.filesToSave.isEmpty()) {
            File file = (File)((ConcurrentHashMap.KeySetView)this.filesToSave.keySet()).iterator().next();
            NBTTagCompound nbt = this.filesToSave.remove(file);
            if (nbt != null) {
                try {
                    this.lockFile(file);
                    try {
                        if (nbt == DELETE_NBT) {
                            if (file.exists()) {
                                file.delete();
                            }
                        } else {
                            try {
                                file.getParentFile().mkdirs();
                                CompressedStreamTools.func_74793_a((NBTTagCompound)nbt, (File)file);
                            }
                            catch (Exception ex) {
                                TheBetweenlands.logger.error("Failed to save region or local storage: " + file.getAbsolutePath(), (Throwable)ex);
                            }
                        }
                    }
                    finally {
                        this.unlockFile(file);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            return true;
        }
        return false;
    }

    public void flush() {
        while (this.func_75814_c()) {
        }
    }
}

