/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.location;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.entity.mobs.EntityChiromawHatchling;
import thebetweenlands.common.entity.mobs.EntityChiromawMatriarch;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationGuarded;

public class LocationChiromawMatriarchNest
extends LocationGuarded {
    private static final int RESPAWN_TIME = 120;
    private BlockPos nest;
    private int respawnCounter = 0;

    public LocationChiromawMatriarchNest(IWorldStorage worldStorage, StorageID id, LocalRegion region) {
        super(worldStorage, id, region, "chiromaw_matriarch_nest", EnumLocationType.CHIROMAW_MATRIARCH_NEST);
    }

    public LocationChiromawMatriarchNest(IWorldStorage worldStorage, StorageID id, LocalRegion region, BlockPos nest) {
        super(worldStorage, id, region, "chiromaw_matriarch_nest", EnumLocationType.CHIROMAW_MATRIARCH_NEST);
        this.setNestPosition(nest);
    }

    public void setNestPosition(BlockPos nest) {
        this.nest = nest;
    }

    public BlockPos getNestPosition() {
        return this.nest;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        if (this.nest != null) {
            nbt.func_74768_a("NestX", this.nest.func_177958_n());
            nbt.func_74768_a("NestY", this.nest.func_177956_o());
            nbt.func_74768_a("NestZ", this.nest.func_177952_p());
        }
        nbt.func_74768_a("RespawnCounter", this.respawnCounter);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.nest = new BlockPos(nbt.func_74762_e("NestX"), nbt.func_74762_e("NestY"), nbt.func_74762_e("NestZ"));
        this.respawnCounter = nbt.func_74762_e("RespawnCounter");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        World world = this.getWorldStorage().getWorld();
        if (!world.field_72995_K && this.nest != null && !this.getGuard().isClear(world)) {
            if (!world.func_175647_a(EntityPlayer.class, new AxisAlignedBB(this.nest), player -> !player.func_184812_l_() && !player.func_175149_v()).isEmpty()) {
                this.getGuard().clear(world);
                this.setVisible(false);
                for (EntityPlayerMP player2 : world.func_72872_a(EntityPlayerMP.class, this.getBoundingBox())) {
                    player2.func_146105_b((ITextComponent)new TextComponentTranslation("chat.chiromaw_matriarch_nest.tainted", new Object[0]), false);
                    AdvancementCriterionRegistry.CHIROMAW_MATRIARCH_NEST_CLAIMED.trigger(player2);
                }
            }
            if (world.func_82737_E() % 200L == 0L && world.func_72872_a(EntityChiromawMatriarch.class, this.getBoundingBox().func_186662_g(160.0)).isEmpty()) {
                ++this.respawnCounter;
                if (this.respawnCounter >= 120) {
                    this.respawnCounter = 0;
                    EntityChiromawMatriarch matriarch = new EntityChiromawMatriarch(world);
                    matriarch.func_70107_b((double)this.nest.func_177958_n() + 0.5, (double)this.nest.func_177956_o() + 0.01, (double)this.nest.func_177952_p() + 0.5);
                    if (matriarch.func_70058_J()) {
                        matriarch.func_180482_a(world.func_175649_E(this.nest), null);
                        world.func_72838_d((Entity)matriarch);
                    } else {
                        matriarch.func_70106_y();
                    }
                    if (world.func_72872_a(EntityChiromawHatchling.class, this.getBoundingBox()).isEmpty()) {
                        for (EnumFacing facing : EnumFacing.field_176754_o) {
                            if (!world.field_73012_v.nextBoolean()) continue;
                            BlockPos pos = this.nest.func_177972_a(facing).func_177977_b();
                            EntityChiromawHatchling egg = new EntityChiromawHatchling(world);
                            egg.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.01, (double)pos.func_177952_p() + 0.5);
                            if (egg.func_70058_J()) {
                                world.func_72838_d((Entity)egg);
                                continue;
                            }
                            egg.func_70106_y();
                        }
                    }
                }
            }
        }
    }
}

