/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.compat.jei.BetweenlandsJEIPlugin;

public class DynamicJEIRecipeHandler {
    private static final Map<Integer, List<IRecipeWrapper>> DYNAMIC_RECIPES = new HashMap<Integer, List<IRecipeWrapper>>();

    private DynamicJEIRecipeHandler() {
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        List<IRecipeWrapper> dynamicRecipes = DynamicJEIRecipeHandler.getDynamicRecipes(world);
        if (!dynamicRecipes.isEmpty()) {
            for (IRecipeWrapper recipe : dynamicRecipes) {
                BetweenlandsJEIPlugin.jeiRuntime.getRecipeRegistry().addRecipe((Object)recipe);
            }
            DYNAMIC_RECIPES.put(world.field_73011_w.getDimension(), dynamicRecipes);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        List<IRecipeWrapper> dynamicRecipes = DYNAMIC_RECIPES.get(world.field_73011_w.getDimension());
        if (dynamicRecipes != null) {
            for (IRecipeWrapper recipe : dynamicRecipes) {
                BetweenlandsJEIPlugin.jeiRuntime.getRecipeRegistry().removeRecipe((Object)recipe);
            }
            DYNAMIC_RECIPES.remove(world.field_73011_w.getDimension());
        }
    }

    private static List<IRecipeWrapper> getDynamicRecipes(World world) {
        ArrayList<IRecipeWrapper> dynamicRecipes = new ArrayList<IRecipeWrapper>();
        return dynamicRecipes;
    }
}

