/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.commons.lang3.reflect.MethodUtils;

public class PluginUtil {
    public static void gatherAnnotatedPlugins(Map<Class<?>, IWailaPlugin> plugins) {
        for (ASMDataTable.ASMData data : Waila.plugins) {
            try {
                String requiredMod = (String)data.getAnnotationInfo().get("value");
                if (Strings.isNullOrEmpty((String)requiredMod)) {
                    requiredMod = "anything";
                }
                Waila.LOGGER.debug("Attempting to discover plugin for {} from {}", (Object)requiredMod, (Object)data.getClassName());
                if (Loader.isModLoaded((String)requiredMod) || requiredMod.equalsIgnoreCase("anything")) {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    Class<?> asmClass = Class.forName(data.getClassName());
                    if (IWailaPlugin.class.isAssignableFrom(asmClass)) {
                        plugins.put(asmClass, (IWailaPlugin)asmClass.newInstance());
                        Waila.LOGGER.debug("Successfully discovered plugin for {} from {} in {}", (Object)requiredMod, (Object)data.getClassName(), (Object)stopwatch.stop());
                        continue;
                    }
                    Waila.LOGGER.error("{} attempted to register a plugin for {} that did not implement IWailaPlugin", (Object)data.getClassName(), (Object)requiredMod);
                    continue;
                }
                Waila.LOGGER.error("{} is not loaded. Passing over plugin.", (Object)requiredMod);
            }
            catch (Exception e) {
                Waila.LOGGER.error("Error discovering plugin for class {}: {}", (Object)data.getClassName(), (Object)e.getMessage());
            }
        }
    }

    public static void gatherIMCPlugins(Map<Class<?>, IWailaPlugin> plugins) {
        for (Map.Entry<String, String> entry : ModuleRegistrar.instance().IMCRequests.entrySet()) {
            Method callback = PluginUtil.getCallbackMethod(entry.getKey(), entry.getValue());
            if (callback == null) continue;
            plugins.put(callback.getDeclaringClass(), registrar -> {
                try {
                    callback.invoke(null, ModuleRegistrar.instance());
                }
                catch (Exception e) {
                    Waila.LOGGER.error("Error registering wrapped plugin from {} at {}", entry.getValue(), entry.getKey());
                }
            });
        }
    }

    @Nullable
    private static Method getCallbackMethod(String method, String modname) {
        String[] splitName = method.split("\\.");
        String methodName = splitName[splitName.length - 1];
        String className = method.substring(0, method.length() - methodName.length() - 1);
        Waila.LOGGER.debug("Attempting to wrap reflected plugin at {}.{}", (Object)className, (Object)methodName);
        try {
            Class<?> reflectClass = Class.forName(className);
            Method reflectMethod = MethodUtils.getAccessibleMethod(reflectClass, (String)methodName, (Class[])new Class[]{IWailaRegistrar.class});
            if (reflectMethod == null) {
                throw new NullPointerException("Could not find method.");
            }
            Waila.LOGGER.debug("Successfully wrapped plugin for {} at {}", (Object)modname, (Object)method);
            return reflectMethod;
        }
        catch (Exception e) {
            Waila.LOGGER.warn("Error wrapping plugin at {}: {}: {}", (Object)method, (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
    }
}

