/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IObjectWithProperty;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.IProperties;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.ItemEntryGroup;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.utils.JsonUtils;
import thelm.jaopca.api.utils.Utils;
import thelm.jaopca.modules.ModuleIndustrialCraft;

public class ModuleMekanism
extends ModuleBase {
    public static final HashBasedTable<String, String, Gas> GASES_TABLE = HashBasedTable.create();
    public static final EnumEntryType GAS = EnumEntryType.addEntryType("GAS", ModuleMekanism::checkGasEntry, ModuleMekanism::registerGases, (IProperties)GasProperties.DEFAULT, ModuleMekanism::parseGasPpt);
    public static final GasProperties CLEAN_SLURRY_PROPERTIES = new GasProperties().setIconName("mekanism:blocks/liquid/liquidcleanore").setVisible(false);
    public static final GasProperties SLURRY_PROPERTIES = new GasProperties().setIconName("mekanism:blocks/liquid/liquidore").setVisible(false);
    public static final HashMap<IOreEntry, ItemStack> ORE_BASES = Maps.newHashMap();
    public static final ItemEntry DIRTY_DUST_ENTRY = new ItemEntry(EnumEntryType.ITEM, "dustDirty", new ModelResourceLocation("jaopca:dust_dirty#inventory"), (Collection<String>)ImmutableList.of((Object)"Iron", (Object)"Gold", (Object)"Osmium", (Object)"Copper", (Object)"Tin", (Object)"Silver", (Object)"Lead"));
    public static final ItemEntry CLUMP_ENTRY = new ItemEntry(EnumEntryType.ITEM, "clump", new ModelResourceLocation("jaopca:clump#inventory"), (Collection<String>)ImmutableList.of((Object)"Iron", (Object)"Gold", (Object)"Osmium", (Object)"Copper", (Object)"Tin", (Object)"Silver", (Object)"Lead"));
    public static final ItemEntry SHARD_ENTRY = new ItemEntry(EnumEntryType.ITEM, "shard", new ModelResourceLocation("jaopca:shard#inventory"), (Collection<String>)ImmutableList.of((Object)"Iron", (Object)"Gold", (Object)"Osmium", (Object)"Copper", (Object)"Tin", (Object)"Silver", (Object)"Lead"));
    public static final ItemEntry CRYSTAL_ENTRY = new ItemEntry(EnumEntryType.ITEM, "crystal", new ModelResourceLocation("jaopca:crystal#inventory"), (Collection<String>)ImmutableList.of((Object)"Iron", (Object)"Gold", (Object)"Osmium", (Object)"Copper", (Object)"Tin", (Object)"Silver", (Object)"Lead"));
    public static final ItemEntry CLEAN_SLURRY_ENTRY = new ItemEntry(GAS, "slurryClean", null, (Collection<String>)ImmutableList.of((Object)"Iron", (Object)"Gold", (Object)"Osmium", (Object)"Copper", (Object)"Tin", (Object)"Silver", (Object)"Lead")).setProperties(CLEAN_SLURRY_PROPERTIES).skipWhenGrouped(true);
    public static final ItemEntry SLURRY_ENTRY = new ItemEntry(GAS, "slurry", null, (Collection<String>)ImmutableList.of((Object)"Iron", (Object)"Gold", (Object)"Osmium", (Object)"Copper", (Object)"Tin", (Object)"Silver", (Object)"Lead")).setProperties(SLURRY_PROPERTIES).skipWhenGrouped(true);
    public static final ArrayList<String> MINOR_COMPAT_BLACKLIST = Lists.newArrayList((Object[])new String[]{"Nickel", "Aluminum", "Uranium", "Draconium"});

    @Override
    public String getName() {
        return "mekanism";
    }

    @Override
    public List<String> getDependencies() {
        return Lists.newArrayList((Object[])new String[]{"dust"});
    }

    @Override
    public EnumSet<EnumOreType> getOreTypes() {
        return Utils.enumSetOf((Enum[])EnumOreType.DUSTLESS);
    }

    @Override
    public List<String> getOreBlacklist() {
        return Lists.newArrayList((Object[])new String[]{"Iron", "Gold", "Osmium", "Copper", "Tin", "Silver", "Lead", "Quartz", "Diamond", "Lapis", "Coal", "RefinedObsidian", "Redstone", "RefinedGlowstone", "Bronze"});
    }

    public List<ItemEntryGroup> getItemRequests() {
        return Lists.newArrayList((Object[])new ItemEntryGroup[]{ItemEntryGroup.of(DIRTY_DUST_ENTRY, CLUMP_ENTRY, SHARD_ENTRY, CRYSTAL_ENTRY, CLEAN_SLURRY_ENTRY, SLURRY_ENTRY)});
    }

    @Override
    public void registerConfigs(Configuration config) {
        JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this).stream().filter(entry -> entry.getOreType() == EnumOreType.INGOT && !MINOR_COMPAT_BLACKLIST.contains(entry.getOreName())).forEach(entry -> ORE_BASES.put((IOreEntry)entry, Utils.parseItemStack(config.get(Utils.to_under_score(entry.getOreName()), "mekanismBase", "minecraft:cobblestone", "Item to use when recreating the ore. (Mekanism)").setRequiresMcRestart(true).getString())));
    }

    @Override
    public void init() {
        block6: for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this)) {
            switch (entry.getOreType()) {
                case GEM: {
                    for (Object ore : Utils.getOres("ore" + entry.getOreName())) {
                        ModuleMekanism.addEnrichmentChamberRecipe(Utils.resizeStack((ItemStack)ore, 1), Utils.getOreStack("gem", entry, 2));
                    }
                }
                case GEM_ORELESS: {
                    for (Object ore : Utils.getOres("dust" + entry.getOreName())) {
                        ModuleMekanism.addEnrichmentChamberRecipe(Utils.resizeStack((ItemStack)ore, 1), Utils.getOreStack("gem", entry, 1));
                    }
                    for (Object ore : Utils.getOres("gem" + entry.getOreName())) {
                        ModuleMekanism.addCrusherRecipe(Utils.resizeStack((ItemStack)ore, 1), Utils.getOreStack("dust", entry, 1));
                    }
                    continue block6;
                }
                case INGOT: {
                    if (!MINOR_COMPAT_BLACKLIST.contains(entry.getOreName())) {
                        Object ore;
                        ItemStack base = ORE_BASES.get(entry);
                        for (ItemStack ore2 : Utils.getOres("dust" + entry.getOreName())) {
                            ModuleMekanism.addCombinerRecipe(Utils.resizeStack(ore2, 8), base, Utils.getOreStack("ore", entry, 1));
                        }
                        for (ItemStack ore2 : Utils.getOres("ore" + entry.getOreName())) {
                            ModuleMekanism.addEnrichmentChamberRecipe(Utils.resizeStack(ore2, 1), Utils.getOreStack("dust", entry, 2));
                        }
                        ore = Utils.getOres("ingot" + entry.getOreName()).iterator();
                        while (ore.hasNext()) {
                            ItemStack ore2;
                            ore2 = (ItemStack)ore.next();
                            ModuleMekanism.addCrusherRecipe(Utils.resizeStack(ore2, 1), Utils.getOreStack("dust", entry, 1));
                        }
                    }
                    for (Object ore : Utils.getOres("dustDirty" + entry.getOreName())) {
                        ModuleMekanism.addEnrichmentChamberRecipe(Utils.resizeStack((ItemStack)ore, 1), Utils.getOreStack("dust", entry, 1));
                    }
                    continue block6;
                }
                case INGOT_ORELESS: {
                    for (Object ore : Utils.getOres("ingot" + entry.getOreName())) {
                        ModuleMekanism.addCrusherRecipe(Utils.resizeStack((ItemStack)ore, 1), Utils.getOreStack("dust", entry, 1));
                    }
                    continue block6;
                }
            }
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"dustDirty")) {
            for (Object ore : Utils.getOres("clump" + entry.getOreName())) {
                ModuleMekanism.addCrusherRecipe(Utils.resizeStack((ItemStack)ore, 1), Utils.getOreStack("dustDirty", entry, 1));
            }
            if (!Loader.isModLoaded((String)"ic2")) continue;
            ModuleIndustrialCraft.addMaceratorRecipe("clump" + entry.getOreName(), Utils.getOreStack("dustDirty", entry, 1));
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"clump")) {
            for (Object ore : Utils.getOres("ore" + entry.getOreName())) {
                ModuleMekanism.addPurificationChamberRecipe(Utils.resizeStack((ItemStack)ore, 1), Utils.getOreStack("clump", entry, 3));
            }
            for (Object ore : Utils.getOres("shard" + entry.getOreName())) {
                ModuleMekanism.addPurificationChamberRecipe(Utils.resizeStack((ItemStack)ore, 1), Utils.getOreStack("clump", entry, 1));
            }
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"shard")) {
            for (Object ore : Utils.getOres("ore" + entry.getOreName())) {
                ModuleMekanism.addChemicalInjectionChamberRecipe(Utils.resizeStack((ItemStack)ore, 1), "hydrogenchloride", Utils.getOreStack("shard", entry, 4));
            }
            for (Object ore : Utils.getOres("crystal" + entry.getOreName())) {
                ModuleMekanism.addChemicalInjectionChamberRecipe(Utils.resizeStack((ItemStack)ore, 1), "hydrogenchloride", Utils.getOreStack("shard", entry, 1));
            }
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crystal")) {
            if (!GASES_TABLE.contains((Object)"slurryClean", (Object)entry.getOreName())) continue;
            ModuleMekanism.addChemicalCrystallizerRecipe(new GasStack((Gas)GASES_TABLE.get((Object)"slurryClean", (Object)entry.getOreName()), 200), Utils.getOreStack("crystal", entry, 1));
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"slurryClean")) {
            if (!GASES_TABLE.contains((Object)"slurry", (Object)entry.getOreName())) continue;
            ModuleMekanism.addChemicalWasherRecipe(new GasStack((Gas)GASES_TABLE.get((Object)"slurry", (Object)entry.getOreName()), 1), new GasStack((Gas)GASES_TABLE.get((Object)"slurryClean", (Object)entry.getOreName()), 1));
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"slurry")) {
            for (Object ore : Utils.getOres("ore" + entry.getOreName())) {
                ModuleMekanism.addChemicalDissolutionChamberRecipe(Utils.resizeStack((ItemStack)ore, 1), new GasStack((Gas)GASES_TABLE.get((Object)"slurry", (Object)entry.getOreName()), 1000));
            }
        }
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack output) {
        NBTTagCompound msg = new NBTTagCompound();
        msg.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        msg.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"CrusherRecipe", (NBTTagCompound)msg);
    }

    public static void addCombinerRecipe(ItemStack input, ItemStack extra, ItemStack output) {
        NBTTagCompound msg = new NBTTagCompound();
        msg.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        msg.func_74782_a("extra", (NBTBase)extra.func_77955_b(new NBTTagCompound()));
        msg.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"CombinerRecipe", (NBTTagCompound)msg);
    }

    public static void addEnrichmentChamberRecipe(ItemStack input, ItemStack output) {
        NBTTagCompound msg = new NBTTagCompound();
        msg.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        msg.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"EnrichmentChamberRecipe", (NBTTagCompound)msg);
    }

    public static void addPurificationChamberRecipe(ItemStack input, ItemStack output) {
        Gas gasType = GasRegistry.getGas((String)"oxygen");
        NBTTagCompound msg = new NBTTagCompound();
        msg.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        msg.func_74782_a("gasType", (NBTBase)gasType.write(new NBTTagCompound()));
        msg.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"PurificationChamberRecipe", (NBTTagCompound)msg);
    }

    public static void addChemicalInjectionChamberRecipe(ItemStack input, String gasName, ItemStack output) {
        Gas gasType = GasRegistry.getGas((String)gasName);
        NBTTagCompound msg = new NBTTagCompound();
        msg.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        msg.func_74782_a("gasType", (NBTBase)gasType.write(new NBTTagCompound()));
        msg.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"ChemicalInjectionChamberRecipe", (NBTTagCompound)msg);
    }

    public static void addChemicalCrystallizerRecipe(GasStack input, ItemStack output) {
        NBTTagCompound msg = new NBTTagCompound();
        msg.func_74782_a("input", (NBTBase)input.write(new NBTTagCompound()));
        msg.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"ChemicalCrystallizerRecipe", (NBTTagCompound)msg);
    }

    public static void addChemicalWasherRecipe(GasStack input, GasStack output) {
        NBTTagCompound msg = new NBTTagCompound();
        msg.func_74782_a("input", (NBTBase)input.write(new NBTTagCompound()));
        msg.func_74782_a("output", (NBTBase)output.write(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"ChemicalWasherRecipe", (NBTTagCompound)msg);
    }

    public static void addChemicalDissolutionChamberRecipe(ItemStack input, GasStack output) {
        NBTTagCompound msg = new NBTTagCompound();
        msg.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        msg.func_74782_a("output", (NBTBase)output.write(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"ChemicalDissolutionChamberRecipe", (NBTTagCompound)msg);
    }

    public static boolean checkGasEntry(ItemEntry entry, IOreEntry ore) {
        return false;
    }

    public static void registerGases(ItemEntry entry) {
        GasProperties ppt = (GasProperties)entry.properties;
        for (IOreEntry ore : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)entry.name)) {
            try {
                IGasWithProperty gas = ppt.gasClass.getConstructor(String.class, ItemEntry.class, IOreEntry.class).newInstance(ppt.iconName, entry, ore);
                gas.setVisible(ppt.visible);
                GasRegistry.register((Gas)((Gas)gas));
                GASES_TABLE.put((Object)entry.name, (Object)ore.getOreName(), (Object)((Gas)gas));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static GasProperties parseGasPpt(JsonObject jsonObject, JsonDeserializationContext context) {
        String iconName = JsonUtils.getString(jsonObject, "icon_name", "minecraft:blocks/water_still");
        boolean visible = JsonUtils.getBoolean(jsonObject, "visible", true);
        GasProperties ppt = new GasProperties().setIconName(iconName);
        return ppt;
    }

    public static class GasBase
    extends Gas
    implements IGasWithProperty {
        public final IOreEntry oreEntry;
        public final ItemEntry itemEntry;

        public GasBase(String iconName, ItemEntry itemEntry, IOreEntry oreEntry) {
            super(itemEntry.name + oreEntry.getOreName(), iconName);
            this.setUnlocalizedName("jaopca." + itemEntry.name);
            this.oreEntry = oreEntry;
            this.itemEntry = itemEntry;
        }

        @Override
        public IOreEntry getOreEntry() {
            return this.oreEntry;
        }

        @Override
        public ItemEntry getItemEntry() {
            return this.itemEntry;
        }

        @Override
        public GasBase setVisible(boolean visible) {
            super.setVisible(visible);
            return this;
        }

        public int getTint() {
            return this.oreEntry.getColor();
        }

        public String getLocalizedName() {
            return Utils.smartLocalize(this.getUnlocalizedName(), this.getUnlocalizedName() + ".%s", this.getOreEntry());
        }
    }

    public static interface IGasWithProperty
    extends IObjectWithProperty {
        public IGasWithProperty setVisible(boolean var1);

        @Override
        default public void registerModels() {
        }
    }

    public static class GasProperties
    implements IProperties {
        public static final GasProperties DEFAULT = new GasProperties();
        public String iconName = "minecraft:blocks/water_still";
        public boolean visible = true;
        public Class<? extends IGasWithProperty> gasClass = GasBase.class;

        @Override
        public EnumEntryType getType() {
            return GAS;
        }

        public GasProperties setIconName(String value) {
            this.iconName = value;
            return this;
        }

        public GasProperties setVisible(boolean value) {
            this.visible = value;
            return this;
        }

        public GasProperties setGasClass(Class<? extends IGasWithProperty> value) {
            this.gasClass = value;
            return this;
        }
    }
}

