/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.lib.IRTBlockColor;
import lumien.randomthings.lib.properties.UnlistedBool;
import lumien.randomthings.lib.properties.UnlistedEnum;
import lumien.randomthings.tileentity.TileEntityFluidDisplay;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BlockFluidDisplay
extends BlockContainerBase
implements IRTBlockColor {
    public static final FluidProperty FLUID = new FluidProperty();
    public static final UnlistedBool FLOWING = UnlistedBool.create("flowing");
    public static final UnlistedEnum<Rotation> ROTATION = UnlistedEnum.create("rotation", Rotation.class);

    public BlockFluidDisplay() {
        super("fluidDisplay", Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityFluidDisplay te = (TileEntityFluidDisplay)worldIn.func_175625_s(pos);
        ItemStack heldItem = playerIn.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            FluidStack liquid;
            IFluidHandlerItem handler = (IFluidHandlerItem)heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            IFluidTankProperties[] tanks = handler.getTankProperties();
            if (tanks.length > 0 && (liquid = tanks[0].getContents()) != null) {
                if (!worldIn.field_72995_K) {
                    te.setFluidStack(new FluidStack(liquid.getFluid(), 1000, liquid.tag));
                    te.syncTE();
                }
                return true;
            }
        } else {
            if (!worldIn.field_72995_K) {
                if (playerIn.func_70093_af()) {
                    te.cycleRotation();
                } else {
                    te.toggleFlowing();
                }
            }
            return true;
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{FLOWING, FLUID, ROTATION});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityFluidDisplay te = (TileEntityFluidDisplay)worldIn.func_175625_s(pos);
        IExtendedBlockState actualState = (IExtendedBlockState)state;
        if (te == null) {
            return actualState.withProperty((IUnlistedProperty)FLUID, null).withProperty((IUnlistedProperty)FLOWING, (Object)false);
        }
        return actualState.withProperty((IUnlistedProperty)FLUID, (Object)te.getFluidStack()).withProperty((IUnlistedProperty)FLOWING, (Object)te.flowing()).withProperty(ROTATION, (Object)te.getRotation());
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFluidDisplay();
    }

    @Override
    public int colorMultiplier(IBlockState state, IBlockAccess p_186720_2_, BlockPos pos, int tintIndex) {
        IExtendedBlockState extended;
        FluidStack fluidStack;
        if (tintIndex == 0 && (fluidStack = (FluidStack)(extended = (IExtendedBlockState)state).getValue((IUnlistedProperty)FLUID)) != null) {
            return fluidStack.getFluid().getColor(fluidStack);
        }
        return 0xFFFFFF;
    }

    private static class FluidProperty
    implements IUnlistedProperty<FluidStack> {
        private FluidProperty() {
        }

        public String getName() {
            return "fluid";
        }

        public boolean isValid(FluidStack value) {
            return true;
        }

        public Class<FluidStack> getType() {
            return FluidStack.class;
        }

        public String valueToString(FluidStack value) {
            return value.getLocalizedName();
        }
    }
}

