/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block.plates;

import com.google.common.base.Predicate;
import lumien.randomthings.block.BlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDirectionalAcceleratorPlate
extends BlockBase {
    protected static final AxisAlignedBB AABB = null;
    protected static final AxisAlignedBB VISUAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockDirectionalAcceleratorPlate() {
        super("plate_accelerator_directional", Material.field_151578_c);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canPlaceOn(worldIn, pos.func_177977_b());
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos, EnumFacing.UP);
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceOn(worldIn, pos.func_177977_b())) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return VISUAL_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        EnumFacing acceleratingFacing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
        Vec3d accVector = new Vec3d(acceleratingFacing.func_176730_m()).func_186678_a(0.1);
        Vec3d motionVec = new Vec3d(entityIn.field_70159_w, entityIn.field_70181_x, entityIn.field_70179_y);
        motionVec = motionVec.func_178787_e(accVector);
        if (motionVec.func_189985_c() > 0.25) {
            motionVec = motionVec.func_72432_b().func_186678_a(0.5);
        }
        entityIn.field_70159_w = motionVec.field_72450_a;
        entityIn.field_70181_x = motionVec.field_72448_b;
        entityIn.field_70179_y = motionVec.field_72449_c;
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return currentInput.ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing input = EnumFacing.values()[meta];
        if (FACING.func_177700_c().contains(input)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)input);
        }
        return this.func_176223_P();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }
}

