/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.awt.Color;
import java.util.List;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.lib.IRTItemColor;
import lumien.randomthings.util.ReflectionUtil;
import lumien.randomthings.util.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBiomeCrystal
extends ItemBase
implements IRTItemColor {
    public ItemBiomeCrystal() {
        super("biomeCrystal");
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        String myName = super.func_77653_i(stack);
        Biome biome = ItemBiomeCrystal.getBiome(stack);
        if (biome != null) {
            myName = myName + " (" + ReflectionUtil.getBiomeName(biome) + ")";
        }
        return myName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        Biome biome = ItemBiomeCrystal.getBiome(stack);
        if (biome != null) {
            tooltip.add(biome.func_185359_l());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        Biome biome = ItemBiomeCrystal.getBiome(stack);
        if (biome != null) {
            return RenderUtils.getBiomeColor(null, biome, Minecraft.func_71410_x().field_71439_g.func_180425_c());
        }
        return Color.WHITE.getRGB();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        Biome biome = ItemBiomeCrystal.getBiome(stack);
        if (biome != null) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
        }
        return false;
    }

    public static Biome getBiome(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("biomeName")) {
            String biomeName = compound.func_74779_i("biomeName");
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeName));
            return biome;
        }
        return null;
    }
}

