/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.network.messages;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.item.ItemSoundRecorder;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.network.IRTMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessagePlayedSound
implements IRTMessage {
    String soundName;
    int recorderSlot;

    public MessagePlayedSound() {
    }

    public MessagePlayedSound(String soundName, int recorderSlot) {
        this.soundName = soundName;
        this.recorderSlot = recorderSlot;
    }

    public void fromBytes(ByteBuf buf) {
        this.soundName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.recorderSlot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.soundName);
        buf.writeInt(this.recorderSlot);
    }

    @Override
    public void onMessage(final MessageContext context) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ItemStack recorderStack;
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                if (player != null && MessagePlayedSound.this.recorderSlot >= 0 && MessagePlayedSound.this.recorderSlot < player.field_71071_by.func_70302_i_() && !(recorderStack = player.field_71071_by.func_70301_a(MessagePlayedSound.this.recorderSlot)).func_190926_b() && recorderStack.func_77973_b() == ModItems.soundRecorder) {
                    ItemSoundRecorder.recordSound(recorderStack, MessagePlayedSound.this.soundName);
                }
            }
        });
    }

    @Override
    public Side getHandlingSide() {
        return Side.SERVER;
    }
}

