/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.network.messages;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.handler.spectreilluminator.SpectreIlluminationClientHandler;
import lumien.randomthings.network.IRTMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSpectreIllumination
implements IRTMessage {
    int dimension;
    long chunkLong;
    boolean illuminated;

    public MessageSpectreIllumination() {
    }

    public MessageSpectreIllumination(int dimension, long chunkLong, boolean illuminated) {
        this.dimension = dimension;
        this.chunkLong = chunkLong;
        this.illuminated = illuminated;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.chunkLong = buf.readLong();
        this.illuminated = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeLong(this.chunkLong);
        buf.writeBoolean(this.illuminated);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageContext context) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            WorldClient world = FMLClientHandler.instance().getWorldClient();
            if (world.field_73011_w.getDimension() == this.dimension) {
                SpectreIlluminationClientHandler.setIlluminated(this.chunkLong, this.illuminated);
            }
        });
    }

    @Override
    public Side getHandlingSide() {
        return Side.CLIENT;
    }
}

