/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import lumien.randomthings.block.BlockIronDropper;
import lumien.randomthings.lib.ContainerSynced;
import lumien.randomthings.lib.IRedstoneSensitive;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.RandomUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityIronDropper
extends TileEntityBase
implements IRedstoneSensitive,
ITickable {
    @ContainerSynced
    REDSTONE_MODE redstoneMode = REDSTONE_MODE.REPEAT_POWERED;
    @ContainerSynced
    PICKUP_DELAY pickupDelay = PICKUP_DELAY.TICKS_5;
    @ContainerSynced
    EFFECTS effects = EFFECTS.NONE;
    @ContainerSynced
    boolean randomMotion;
    int dropCounter = 0;

    public TileEntityIronDropper() {
        this.setItemHandler(9);
        this.setItemHandlerPublic(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.dropCounter;
            if (this.dropCounter % 4 == 0 && (this.redstoneMode == REDSTONE_MODE.REPEAT || this.redstoneMode == REDSTONE_MODE.REPEAT_POWERED && this.isPoweredByRedstone())) {
                this.drop();
            }
        }
    }

    private void drop() {
        IItemHandler itemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockIronDropper.FACING);
        BlockPos blockpos = this.field_174879_c.func_177972_a(facing);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(blockpos);
        int slot = 0;
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            slot = i;
            break;
        }
        if (!stack.func_190926_b()) {
            ItemStack toDrop = stack.func_77946_l();
            toDrop.func_190920_e(1);
            if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())), (ItemStack)toDrop, (boolean)false);
                if (result == null || result.func_190916_E() == 0) {
                    itemHandler.extractItem(slot, 1, false);
                }
            } else {
                int pickupDelayInteger;
                itemHandler.extractItem(slot, 1, false);
                double speed = 6.0;
                double posX = (double)this.field_174879_c.func_177958_n() + 0.5 + 0.7 * (double)facing.func_82601_c();
                double posY = (double)this.field_174879_c.func_177956_o() + 0.5 + 0.7 * (double)facing.func_96559_d();
                double posZ = (double)this.field_174879_c.func_177952_p() + 0.5 + 0.7 * (double)facing.func_82599_e();
                posY = facing.func_176740_k() == EnumFacing.Axis.Y ? (posY -= 0.125) : (posY -= 0.15625);
                EntityItem entityItem = new EntityItem(this.field_145850_b, posX, posY, posZ, toDrop);
                switch (this.pickupDelay) {
                    case NONE: {
                        pickupDelayInteger = 0;
                        break;
                    }
                    case TICKS_20: {
                        pickupDelayInteger = 20;
                        break;
                    }
                    case TICKS_5: {
                        pickupDelayInteger = 5;
                        break;
                    }
                    default: {
                        pickupDelayInteger = 0;
                    }
                }
                entityItem.func_174867_a(pickupDelayInteger);
                double d3 = this.randomMotion ? this.field_145850_b.field_73012_v.nextDouble() * 0.1 + 0.2 : 0.25;
                entityItem.field_70159_w = (double)facing.func_82601_c() * d3;
                entityItem.field_70181_x = 0.2f;
                entityItem.field_70179_y = (double)facing.func_82599_e() * d3;
                if (this.randomMotion) {
                    entityItem.field_70159_w += this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0075f * speed;
                    entityItem.field_70181_x += this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0075f * speed;
                    entityItem.field_70179_y += this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0075f * speed;
                } else {
                    entityItem.field_70159_w += (double)facing.func_82601_c() * 0.5 * (double)0.0075f * speed;
                    entityItem.field_70181_x += (double)facing.func_96559_d() * 0.5 * (double)0.0075f * speed;
                    entityItem.field_70179_y += (double)facing.func_82599_e() * 0.5 * (double)0.0075f * speed;
                }
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
            if (this.effects == EFFECTS.SOUND || this.effects == EFFECTS.SOUND_PARTICLE) {
                this.field_145850_b.func_175718_b(1000, this.field_174879_c, 0);
            }
            if (this.effects == EFFECTS.PARTICLE || this.effects == EFFECTS.SOUND_PARTICLE) {
                this.field_145850_b.func_175718_b(2000, this.field_174879_c, facing.func_82601_c() + 1 + (facing.func_82599_e() + 1) * 3);
            }
        }
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("redstoneMode", this.redstoneMode.ordinal());
        compound.func_74768_a("dropCounter", this.dropCounter);
        compound.func_74768_a("pickupDelay", this.pickupDelay.ordinal());
        compound.func_74757_a("randomMotion", this.randomMotion);
        compound.func_74768_a("effects", this.effects.ordinal());
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        this.redstoneMode = REDSTONE_MODE.values()[compound.func_74762_e("redstoneMode")];
        this.dropCounter = compound.func_74762_e("dropCounter");
        this.pickupDelay = PICKUP_DELAY.values()[compound.func_74762_e("pickupDelay")];
        this.randomMotion = compound.func_74767_n("randomMotion");
        this.effects = EFFECTS.values()[compound.func_74762_e("effects")];
    }

    @Override
    public boolean syncAdditionalData() {
        return false;
    }

    @Override
    public void redstoneChange(boolean oldState, boolean newState) {
        if (this.redstoneMode == REDSTONE_MODE.PULSE && newState) {
            this.drop();
        }
    }

    public REDSTONE_MODE getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(REDSTONE_MODE redstoneMode) {
        this.redstoneMode = redstoneMode;
    }

    public void rotateRedstoneMode() {
        this.redstoneMode = RandomUtil.rotateEnum(this.redstoneMode);
    }

    public void rotatePickupDelay() {
        this.pickupDelay = RandomUtil.rotateEnum(this.pickupDelay);
    }

    public void rotateRandomMotion() {
        this.randomMotion = !this.randomMotion;
    }

    public void rotateEffects() {
        this.effects = RandomUtil.rotateEnum(this.effects);
    }

    public static enum EFFECTS {
        NONE,
        SOUND,
        PARTICLE,
        SOUND_PARTICLE;

    }

    public static enum PICKUP_DELAY {
        NONE,
        TICKS_5,
        TICKS_20;

    }

    public static enum REDSTONE_MODE {
        PULSE,
        REPEAT_POWERED,
        REPEAT;

    }
}

