/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.util;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtil {
    public static boolean areItemStackContentEqual(ItemStack is1, ItemStack is2) {
        if (is1.func_190926_b() || is2.func_190926_b()) {
            return false;
        }
        if (is1.func_77973_b() != is2.func_77973_b()) {
            return false;
        }
        if (!ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2)) {
            return false;
        }
        return is1.func_77952_i() == is2.func_77952_i();
    }

    public static boolean areOreDictionaried(ItemStack is1, ItemStack is2) {
        if (is1.func_190926_b() || is2.func_190926_b()) {
            return false;
        }
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)is1);
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)is2);
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    public static void giveItemToPlayerSilent(EntityPlayer player, @Nonnull ItemStack stack, int preferredSlot) {
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        World world = player.field_70170_p;
        ItemStack remainder = stack;
        if (preferredSlot >= 0) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        if (!remainder.func_190926_b()) {
            remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)remainder, (boolean)false);
        }
        if (!(player instanceof FakePlayer) && (remainder.func_190926_b() || remainder.func_190916_E() != stack.func_190916_E())) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (!remainder.func_190926_b() && !world.field_72995_K) {
            EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, stack);
            entityitem.func_174867_a(40);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void setHeldItemSilent(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemUtil.setItemStackToSlotSilent(player, EntityEquipmentSlot.MAINHAND, stack);
        } else {
            ItemUtil.setItemStackToSlotSilent(player, EntityEquipmentSlot.OFFHAND, stack);
        }
    }

    public static void setItemStackToSlotSilent(EntityPlayer player, EntityEquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)stack);
        } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)stack);
        } else if (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            player.field_71071_by.field_70460_b.set(slotIn.func_188454_b(), (Object)stack);
        }
    }
}

