/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.minecraft.forge.Config;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.coremod.CorePlugin;
import com.endertech.minecraft.forge.coremod.names.NotchMcp;
import com.endertech.minecraft.forge.messages.TileSharedDataMsg;
import com.endertech.minecraft.forge.messages.UpdateBlockMsg;
import com.endertech.minecraft.forge.messages.UsingItemMsg;
import com.endertech.minecraft.forge.player.MotionController;
import com.endertech.minecraft.forge.versions.EndertechMods;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.forge.world.Wind;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.SystemUtils;

@Mod(modid="forgeendertech", name="Forge Endertech", version="1.12.2-4.5.1.0", guiFactory="com.endertech.minecraft.forge.Config$Factory", acceptedMinecraftVersions="[1.12.2]")
public class ForgeMain
extends ForgeMod {
    public static final String ID = "forgeendertech";
    public static final String NAME = "Forge Endertech";
    public static final String GUI_FACTORY = "com.endertech.minecraft.forge.Config$Factory";
    public static final String ACCEPTED = "[1.12.2]";
    public static final String DEPENDENCIES = "required-after:forgeendertech@[1.12.2-4.5.1.0,)";
    @Mod.Instance(value="forgeendertech")
    public static ForgeMain instance;
    static boolean debug;

    public static boolean isDebugMode() {
        return debug;
    }

    public static void debugMsg(String msg) {
        if (ForgeMain.isDebugMode()) {
            System.out.println(msg);
        }
    }

    public static void developMsg(String msg) {
        if (!CorePlugin.obfuscatedCode() && ID.indexOf(SystemUtils.getUserHome().getName().toLowerCase()) == 5) {
            ForgeMain.debugMsg(msg);
        }
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.setConfig(new Config(ID, event));
        this.getRegistrator().registerNetMessageHandledOnBothSides(MotionController.MotionMsg.class, MotionController.MotionMsg.Handler.class);
        this.getRegistrator().registerNetMessageHandledOnServer(UsingItemMsg.class, UsingItemMsg.Handler.class);
        this.getRegistrator().registerNetMessageHandledOnClient(UpdateBlockMsg.class, UpdateBlockMsg.Handler.class);
        this.getRegistrator().registerNetMessageHandledOnBothSides(TileSharedDataMsg.class, TileSharedDataMsg.Handler.class);
        this.getRegistrator().registerNetMessageHandledOnClient(Wind.WindMsg.class, Wind.WindMsg.Handler.class);
        super.preInit(event);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ForgeWorld.isWeather2Loaded = Loader.isModLoaded((String)"weather2");
        super.init(event);
    }

    @Override
    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        EndertechMods.scheduleIntegrityCheckOnce();
        super.initClient(event);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NotchMcp.clearLists();
        super.postInit(event);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ForgeMod getInstance() {
        return instance;
    }

    static {
        debug = false;
    }
}

