/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.google.common.base.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockStateCarrier
extends ForgeEntity {
    private static final DataParameter<Optional<IBlockState>> CARRIED_BLOCK_STATE = EntityDataManager.func_187226_a(BlockStateCarrier.class, (DataSerializer)DataSerializers.field_187197_g);

    public BlockStateCarrier(World world, BlockPos pos, IBlockState carriedState) {
        super(world);
        Vect3d centeredPos = BlockStateCarrier.getCenteredPosTo(pos);
        this.setAllPositions(centeredPos);
        this.setCarriedBlockState(carriedState);
    }

    public BlockStateCarrier(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CARRIED_BLOCK_STATE, (Object)Optional.absent());
        this.func_70105_a(0.98f, 0.98f);
    }

    @Nullable
    public IBlockState getCarriedBlockState() {
        return (IBlockState)((Optional)this.func_184212_Q().func_187225_a(CARRIED_BLOCK_STATE)).orNull();
    }

    protected void setCarriedBlockState(@Nullable IBlockState newState) {
        this.func_184212_Q().func_187227_b(CARRIED_BLOCK_STATE, (Object)Optional.fromNullable((Object)newState));
    }

    @Nullable
    public ResourceLocation getTextureLocation() {
        IBlockState state = this.getCarriedBlockState();
        if (state != null && state.func_177230_c() instanceof ForgeBlock) {
            ForgeBlock block = (ForgeBlock)state.func_177230_c();
            ResourceLocation location = block.getTextureLocationFor(state);
            return location;
        }
        return null;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        IBlockState state = this.getCarriedBlockState();
        if (state != null) {
            tag.func_74768_a(Tags.CARRIED_STATE.name(), Block.func_176210_f((IBlockState)state));
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b(Tags.CARRIED_STATE.name())) {
            int id = tag.func_74762_e(Tags.CARRIED_STATE.name());
            IBlockState state = Block.func_176220_d((int)id);
            this.func_184212_Q().func_187227_b(CARRIED_BLOCK_STATE, (Object)Optional.of((Object)state));
        }
    }

    private static enum Tags {
        CARRIED_STATE;

    }
}

