/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.player;

import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.messages.ForgeNetMsgHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

@Mod.EventBusSubscriber
public class MotionController {
    protected static Map<Entity, Vect3d> motionsMap = new ConcurrentHashMap<Entity, Vect3d>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map.Entry<Entity, Vect3d> entry : motionsMap.entrySet()) {
                Entity entity = entry.getKey();
                Vect3d motion = entry.getValue();
                ForgeEntity.addMotion(entity, motion);
                if (!(entity instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)entity;
                MotionController.sendMotionToPlayer(player, MotionMsg.Type.ADD, motion);
            }
            motionsMap.clear();
        }
    }

    public static void addMotionFor(Entity entity, Vect3d motion) {
        Vect3d mapedMotion = motionsMap.getOrDefault(entity, Vect3d.ZERO);
        Vect3d newMotion = mapedMotion.add(motion);
        motionsMap.put(entity, newMotion);
    }

    public static void setMotionFor(Entity entity, Vect3d motion) {
        ForgeEntity.setMotion(entity, motion);
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            MotionController.sendMotionToPlayer(player, MotionMsg.Type.SET, motion);
        }
        motionsMap.remove(entity);
    }

    protected static void sendMotionToPlayer(EntityPlayerMP player, MotionMsg.Type type, Vect3d motion) {
        MotionMsg message = MotionMsg.addMotion(player, motion);
        ForgeMain.instance.getConnection().sendToPlayer(message, player);
    }

    public static class MotionMsg
    extends ForgeNetMsg {
        public int id = -1;
        public Type type = Type.ADD;
        public Vect3d motion = Vect3d.ZERO;

        public MotionMsg() {
        }

        public MotionMsg(EntityPlayerMP player, Type type, Vect3d motion) {
            this.id = ForgeEntity.getId((Entity)player);
            this.type = type;
            this.motion = motion;
        }

        public static MotionMsg setMotion(EntityPlayerMP player, Vect3d motion) {
            return new MotionMsg(player, Type.SET, motion);
        }

        public static MotionMsg addMotion(EntityPlayerMP player, Vect3d motion) {
            return new MotionMsg(player, Type.ADD, motion);
        }

        public static class Handler
        extends ForgeNetMsgHandler<MotionMsg> {
            public MotionMsg onMessage(MotionMsg message, MessageContext ctx) {
                this.addScheduledTask(ctx, () -> {
                    EntityPlayer player = this.getPlayer(ctx);
                    if (player != null) {
                        switch (message.type) {
                            case ADD: {
                                ForgeEntity.addMotion((Entity)player, message.motion);
                                break;
                            }
                            case SET: {
                                ForgeEntity.setMotion((Entity)player, message.motion);
                                break;
                            }
                        }
                    }
                });
                return null;
            }
        }

        public static enum Type {
            ADD,
            SET;

        }
    }
}

