/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.plugins.general.material;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;
import org.softc.armoryexpansion.client.integration.aelib.plugins.tinkers_construct.material.MaterialRenderHelper;
import org.softc.armoryexpansion.client.integration.aelib.plugins.tinkers_construct.material.MaterialRenderType;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.IBasicMaterial;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.smeltery.block.BlockMolten;

public abstract class BasicMaterial
implements IBasicMaterial {
    protected String identifier;
    protected int color;
    protected MaterialRenderType type = MaterialRenderType.DEFAULT;
    protected ResourceLocation texture;
    private boolean castable;
    private boolean craftable;

    protected BasicMaterial() {
    }

    protected BasicMaterial(String identifier, int color, MaterialRenderType type) {
        this.identifier = identifier;
        this.color = color;
        this.type = type;
    }

    public void setCastable(boolean castable) {
        this.castable = castable;
    }

    public void setCraftable(boolean craftable) {
        this.craftable = craftable;
    }

    @Override
    public boolean isCastable() {
        return this.castable;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public MaterialRenderType getType() {
        return this.type;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public boolean registerTinkersMaterial(boolean canRegister) {
        if (!canRegister || !"unknown".equals(TinkerRegistry.getMaterial((String)this.identifier).getIdentifier())) {
            return false;
        }
        Material material = new Material(this.identifier, this.color);
        material.setCastable(this.castable).setCraftable(this.craftable).addItemIngot(this.identifier);
        if (Side.CLIENT == FMLCommonHandler.instance().getSide()) {
            MaterialRenderHelper.setMaterialRenderInfo(material, this);
        }
        this.registerTinkersFluid(true);
        TinkerRegistry.addMaterial((Material)material);
        TinkerRegistry.integrate((Material)material);
        return true;
    }

    @Override
    public boolean registerTinkersFluid(boolean canRegister) {
        if (!canRegister || !this.castable) {
            return false;
        }
        FluidMolten materialFluid = new FluidMolten(this.getFluidName(), this.color);
        materialFluid.setUnlocalizedName(this.getFluidName());
        FluidRegistry.registerFluid((Fluid)materialFluid);
        FluidRegistry.addBucketForFluid((Fluid)materialFluid);
        return true;
    }

    @Override
    public boolean registerTinkersFluidIMC(boolean canRegister) {
        if (!canRegister || !this.castable) {
            return false;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluid", this.getFluidName());
        tag.func_74778_a("ore", this.identifier);
        tag.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
        return true;
    }

    @Override
    public String getFluidName() {
        return "molten_" + this.identifier;
    }

    @Override
    public FluidMolten getFluid() {
        return new FluidMolten(this.getFluidName(), this.color);
    }

    @Override
    public Block getFluidBlock() {
        return new BlockMolten((Fluid)this.getFluid());
    }

    public boolean equals(Object obj) {
        return obj instanceof BasicMaterial && this.identifier.equals(((IBasicMaterial)obj).getIdentifier());
    }
}

