/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.modsupport;

import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.softc.armoryexpansion.ArmoryExpansion;
import org.softc.armoryexpansion.client.integration.aelib.plugins.tinkers_construct.material.MaterialRenderType;
import org.softc.armoryexpansion.common.integration.aelib.integration.JsonIntegration;
import org.softc.armoryexpansion.common.integration.aelib.plugins.constructsarmory.material.ArmorMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.constructsarmory.material.IArmorMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.IBasicMaterial;
import org.softc.armoryexpansion.common.util.Math;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Mod(modid="armoryexpansion-conarm", name="Armory Expansion - Construct's Armory", version="1.4.1", dependencies="required-after:armoryexpansion; after:*", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ConArmIntegration
extends JsonIntegration {
    static final String MODID = "armoryexpansion-conarm";
    static final String NAME = "Armory Expansion - Construct's Armory";
    static final String DEPENDENCIES = "required-after:armoryexpansion; after:*";
    private static final float STAT_MULT = 1.25f;
    private static final int DURA_MIN = 1;
    private static final int DURA_MAX = 120;
    private static final int DEF_MIN = 0;
    private static final int DEF_MAX = 50;
    private static final int TOUGH_MIN = 0;
    private static final int TOUGH_MAX = 5;
    private Collection<ArmorMaterial> jsonMaterials = new LinkedList<ArmorMaterial>();

    public ConArmIntegration() {
        super("conarm", "armoryexpansion", "conarm");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.modId = "conarm";
        this.logger = event.getModLog();
        this.configDir = event.getModConfigurationDirectory().getPath();
        if (ArmoryExpansion.isIntegrationEnabled(this.modId)) {
            this.loadMaterialsFromOtherIntegrations(event);
            this.loadIntegrationData(this.configDir);
            this.integrationConfigHelper.syncConfig(this.materials);
            this.saveIntegrationData(this.configDir);
            this.registerMaterialStats();
        }
        ArmoryExpansion.getConfig().save();
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerItems(RegistryEvent<Item> event) {
        if (ArmoryExpansion.isIntegrationEnabled(this.modId)) {
            this.loadIntegrationData(this.configDir);
            this.integrationConfigHelper.syncConfig(this.materials);
            this.saveIntegrationData(this.configDir);
            this.registerMaterialStats();
        }
        ArmoryExpansion.getConfig().save();
    }

    private void loadMaterialsFromOtherIntegrations(FMLPreInitializationEvent event) {
        this.loadJsonMaterialsFromOtherIntegrations(event);
    }

    private void loadJsonMaterialsFromOtherIntegrations(FMLPreInitializationEvent event) {
        File jsonDir = new File(event.getModConfigurationDirectory().getPath() + "/" + "armoryexpansion" + "/");
        jsonDir.mkdirs();
        for (File json : Objects.requireNonNull(jsonDir.listFiles((dir, name) -> name.contains("-materials.json") && !name.contains("conarm")))) {
            this.loadMaterialsFromOtherIntegration(json);
        }
    }

    private void loadMaterialsFromOtherIntegration(File file) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        try {
            Collections.addAll(this.jsonMaterials, (Object[])gson.fromJson((Reader)new FileReader(file), ArmorMaterial[].class));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void addMaterial(IBasicMaterial material) {
        if (this.isMaterialEnabled(material.getIdentifier())) {
            this.materials.putIfAbsent(material.getIdentifier(), material);
        }
    }

    @Override
    protected void loadMaterialsFromSource() {
        TinkerRegistry.getAllMaterials().stream().filter(this::isConversionAvailable).map(material -> this.newTiCMaterial((Material)material, TinkerMaterials.iron)).filter(material -> !this.jsonMaterials.contains(material)).forEach(material -> this.addMaterial((IBasicMaterial)((Object)material)));
    }

    private boolean isConversionAvailable(Material material) {
        boolean core = !material.hasStats(ArmorMaterialType.CORE) && material.hasStats("head");
        boolean plates = !material.hasStats(ArmorMaterialType.PLATES) && material.hasStats("handle");
        boolean trim = !material.hasStats(ArmorMaterialType.TRIM) && material.hasStats("extra");
        return core || plates || trim;
    }

    private IArmorMaterial newTiCMaterial(Material material, Material baseMaterial) {
        ArmorMaterial armorMaterial = new ArmorMaterial(material.identifier, material.materialTextColor, MaterialRenderType.METAL, this.getCoreMaterialStats(material, baseMaterial), this.getPlatesMaterialStats(material, baseMaterial), this.getTrimMaterialStats(material, baseMaterial));
        armorMaterial.setCastable(material.isCastable());
        armorMaterial.setCraftable(material.isCraftable());
        return armorMaterial;
    }

    private CoreMaterialStats getCoreMaterialStats(Material material, Material baseMaterial) {
        return new CoreMaterialStats((float)this.calculateDurability(material, baseMaterial), this.calculateDefense(material, baseMaterial));
    }

    private PlatesMaterialStats getPlatesMaterialStats(Material material, Material baseMaterial) {
        return new PlatesMaterialStats(this.calculateDefense(material, baseMaterial), this.calculateExtraDurability(material, baseMaterial), this.calculateToughness(material, baseMaterial));
    }

    private TrimMaterialStats getTrimMaterialStats(Material material, Material baseMaterial) {
        return new TrimMaterialStats(this.calculateExtraDurability(material, baseMaterial));
    }

    private int calculateDurability(Material material, CoreMaterialStats core, HeadMaterialStats head) {
        HeadMaterialStats materialHead = (HeadMaterialStats)material.getStats("head");
        return null != materialHead ? (int)Math.clamp(core.durability * (float)materialHead.durability / (float)head.durability / 1.25f, 1.0f, 120.0f) : 0;
    }

    private int calculateDurability(Material material, Material baseMaterial) {
        return this.calculateDurability(material, (CoreMaterialStats)baseMaterial.getStats(ArmorMaterialType.CORE), (HeadMaterialStats)baseMaterial.getStats("head"));
    }

    private float calculateDefense(Material material, CoreMaterialStats core, HeadMaterialStats head) {
        HeadMaterialStats materialHead = (HeadMaterialStats)material.getStats("head");
        return null != materialHead ? Math.clamp(1.5f * core.defense * materialHead.attack / head.attack / 1.25f, 0.0f, 50.0f) : 0.0f;
    }

    private float calculateDefense(Material material, Material baseMaterial) {
        return this.calculateDefense(material, (CoreMaterialStats)baseMaterial.getStats(ArmorMaterialType.CORE), (HeadMaterialStats)baseMaterial.getStats("head"));
    }

    private float calculateToughness(Material material, PlatesMaterialStats plates, HandleMaterialStats handle) {
        HandleMaterialStats materialHandle = (HandleMaterialStats)material.getStats("handle");
        return null != materialHandle ? Math.clamp(3.0f * plates.toughness * (float)materialHandle.durability / (float)handle.durability / 1.25f, 0.0f, 5.0f) : 0.0f;
    }

    private float calculateToughness(Material material, Material baseMaterial) {
        return this.calculateToughness(material, (PlatesMaterialStats)baseMaterial.getStats(ArmorMaterialType.PLATES), (HandleMaterialStats)baseMaterial.getStats("handle"));
    }

    private float calculateExtraDurability(Material material, TrimMaterialStats trim, ExtraMaterialStats extra) {
        ExtraMaterialStats materialExtra = (ExtraMaterialStats)material.getStats("extra");
        return null != materialExtra ? 2.0f * trim.extraDurability * (float)materialExtra.extraDurability / (float)extra.extraDurability / 1.25f : 0.0f;
    }

    private float calculateExtraDurability(Material material, Material baseMaterial) {
        return this.calculateExtraDurability(material, (TrimMaterialStats)baseMaterial.getStats(ArmorMaterialType.TRIM), (ExtraMaterialStats)baseMaterial.getStats("extra"));
    }
}

