/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.objects.entities.tnt;

import ghostgaming.explosivesmod.GhostsExplosives;
import ghostgaming.explosivesmod.objects.blocks.BlockTNTGhostsExplosives;
import ghostgaming.explosivesmod.objects.entities.EntityTNTGhostsExplosivesStaged;
import ghostgaming.explosivesmod.objects.explosions.ExplosionGhostsExplosives;
import ghostgaming.explosivesmod.util.config.ConfigBlockDuplicatingTNT;
import ghostgaming.explosivesmod.util.config.ConfigBlockTNT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;

public class EntitySpiralTNT
extends EntityTNTGhostsExplosivesStaged {
    public static DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntitySpiralTNT.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> STAGE = EntityDataManager.func_187226_a(EntitySpiralTNT.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySpiralTNT(World world) {
        super(world);
    }

    public EntitySpiralTNT(World world, double x, double y, double z, EntityLivingBase igniter, BlockTNTGhostsExplosives defusedBlock) {
        super(world, x, y, z, igniter, defusedBlock);
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)this.getConfig().FUSE);
        this.field_70180_af.func_187214_a(STAGE, (Object)0);
    }

    @Override
    public DataParameter<Integer> getFuseDataParameter() {
        return FUSE;
    }

    @Override
    public DataParameter<Integer> getStageDataParameter() {
        return STAGE;
    }

    @Override
    public void explode() {
        ConfigBlockDuplicatingTNT config = (ConfigBlockDuplicatingTNT)this.getConfig();
        if (this.getStage() == 0) {
            this.createTNT(config.DUPLICATION_AMOUNT);
        } else {
            ExplosionGhostsExplosives explosion = new ExplosionGhostsExplosives(this.field_70170_p, this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, config.EXPLOSION_STRENGTH, config.EXPLOSION_SMOOTHNESS, false, config.DAMAGES_TERRAIN, config.DROP_BLOCKS, config.HURT_ENTITIES, config.HURT_PLAYERS);
            explosion.doExplosionA();
            explosion.doExplosionB(true);
        }
    }

    @Override
    public ConfigBlockTNT getConfig() {
        return GhostsExplosives.CONFIG_TNT_SPIRAL;
    }

    private void createTNT(int amount) {
        Vector tntDirection = new Vector(0.2, 0.0);
        for (int i = 0; i < amount; ++i) {
            EntitySpiralTNT entityTNT = new EntitySpiralTNT(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.tntPlacedBy, this.tntBlock);
            entityTNT.field_70159_w = tntDirection.getX();
            entityTNT.field_70181_x = 1.3;
            entityTNT.field_70179_y = tntDirection.getZ();
            entityTNT.setStage(1);
            entityTNT.setFuse(fuseLength / 2);
            this.field_70170_p.func_72838_d((Entity)entityTNT);
            Vector verticalVector = new Vector(tntDirection.getZ(), -tntDirection.getX());
            double length = Math.sqrt(verticalVector.getX() * verticalVector.getX() + verticalVector.getZ() * verticalVector.getZ());
            verticalVector.multiply(new Vector(0.2 / length, 0.2 / length));
            tntDirection.add(verticalVector);
        }
    }

    private class Vector {
        private double x;
        private double z;

        public Vector(double x, double z) {
            this.x = x;
            this.z = z;
        }

        public double getX() {
            return this.x;
        }

        public double getZ() {
            return this.z;
        }

        public void add(Vector vector) {
            this.x += vector.getX();
            this.z += vector.getZ();
        }

        public void multiply(Vector vector) {
            this.x *= vector.getX();
            this.z *= vector.getZ();
        }
    }
}

