/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.objects.explosions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import ghostgaming.explosivesmod.init.BlockInit;
import ghostgaming.explosivesmod.init.PotionInit;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionNuclearTNT {
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Random random = new Random();
    private Explosion explosion;
    private final Entity exploder;
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final Vec3d position;
    private final float size;
    private final int smoothness;
    private final boolean damagesTerrain;
    private final boolean dropsBlocks;
    private final boolean hurtsEntities;
    private final boolean hurtsPlayers;
    private final boolean inflictsRadiation;
    private final boolean nuclearWaste;

    public ExplosionNuclearTNT(World world, Entity entity, double x, double y, double z, float size, int smoothness, boolean damagesTerrain, boolean dropsBlocks, boolean hurtsEntities, boolean hurtsPlayers, boolean inflictsRadiation, boolean nuclearWaste) {
        this.exploder = entity;
        this.explosion = new Explosion(world, entity, x, y, z, size, false, damagesTerrain);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.position = new Vec3d(this.x, this.y, this.z);
        this.size = size;
        this.smoothness = smoothness;
        this.damagesTerrain = damagesTerrain;
        this.dropsBlocks = dropsBlocks;
        this.hurtsEntities = hurtsEntities;
        this.hurtsPlayers = hurtsPlayers;
        this.inflictsRadiation = inflictsRadiation;
        this.nuclearWaste = nuclearWaste;
    }

    public void doExplosionA() {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < this.smoothness; ++j) {
            for (int k = 0; k < this.smoothness; ++k) {
                for (int l = 0; l < this.smoothness; ++l) {
                    if (j != 0 && j != this.smoothness - 1 && k != 0 && k != this.smoothness - 1 && l != 0 && l != this.smoothness - 1) continue;
                    double d0 = (float)j / (float)(this.smoothness - 1) * 2.0f - 1.0f;
                    double d1 = (float)k / (float)(this.smoothness - 1) * 2.0f - 1.0f;
                    double d2 = (float)l / (float)(this.smoothness - 1) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double posX = this.x;
                    double posY = this.y;
                    double posZ = this.z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockPos = new BlockPos(posX, posY, posZ);
                        IBlockState blockstate = this.world.func_180495_p(blockPos);
                        if (blockstate.func_185904_a() != Material.field_151579_a) {
                            float explosionResistance = this.exploder != null ? this.exploder.func_180428_a(this.explosion, this.world, blockPos, blockstate) : blockstate.func_177230_c().getExplosionResistance(this.world, blockPos, (Entity)null, this.explosion);
                            f -= (explosionResistance + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a(this.explosion, this.world, blockPos, blockstate, f))) {
                            set.add(blockPos);
                        }
                        posX += d0 * (double)0.3f;
                        posY += d1 * (double)0.3f;
                        posZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float damageRadius = this.size * 2.0f;
        int fromX = MathHelper.func_76128_c((double)(this.x - (double)damageRadius - 1.0));
        int toX = MathHelper.func_76128_c((double)(this.x + (double)damageRadius + 1.0));
        int fromY = MathHelper.func_76128_c((double)(this.y - (double)damageRadius - 1.0));
        int toY = MathHelper.func_76128_c((double)(this.y + (double)damageRadius + 1.0));
        int fromZ = MathHelper.func_76128_c((double)(this.z - (double)damageRadius - 1.0));
        int toZ = MathHelper.func_76128_c((double)(this.z + (double)damageRadius + 1.0));
        List entitiesInExplosionRadius = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)fromX, (double)fromY, (double)fromZ, (double)toX, (double)toY, (double)toZ));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this.explosion, (List)entitiesInExplosionRadius, (double)damageRadius);
        for (int i = 0; i < entitiesInExplosionRadius.size(); ++i) {
            EntityPlayer entityplayer;
            double distanceZ;
            double distanceY;
            double distanceX;
            double distanceFromCenter;
            double distanceFromCenterRelativeToRadius;
            Entity entity = (Entity)entitiesInExplosionRadius.get(i);
            if (entity.func_180427_aV() || !((distanceFromCenterRelativeToRadius = entity.func_70011_f(this.x, this.y, this.z) / (double)damageRadius) <= 1.0) || (distanceFromCenter = (double)MathHelper.func_76133_a((double)((distanceX = entity.field_70165_t - this.x) * distanceX + (distanceY = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * distanceY + (distanceZ = entity.field_70161_v - this.z) * distanceZ))) == 0.0) continue;
            distanceX /= distanceFromCenter;
            distanceY /= distanceFromCenter;
            distanceZ /= distanceFromCenter;
            double blockDensityAtPosition = this.world.func_72842_a(this.position, entity.func_174813_aQ());
            double damage = (1.0 - distanceFromCenterRelativeToRadius) * blockDensityAtPosition;
            if (this.inflictsRadiation && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(PotionInit.POTION_RADIATION_POISONING, 1200, 2));
            }
            if (!(entity instanceof EntityPlayer) && this.hurtsEntities || entity instanceof EntityPlayer && this.hurtsPlayers) {
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this.explosion), (float)((int)((damage * damage + damage) / 2.0 * ((double)this.size * 4.0 - 1.0) * ((double)damageRadius + 1.0) * 2.0)));
            }
            double blastDamageReduction = damage;
            if (entity instanceof EntityLivingBase) {
                blastDamageReduction = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)damage);
            }
            entity.field_70159_w += distanceX * blastDamageReduction * 2.0;
            entity.field_70181_x += distanceY * blastDamageReduction * 2.0;
            entity.field_70179_y += distanceZ * blastDamageReduction * 2.0;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.playerKnockbackMap.put(entityplayer, new Vec3d(distanceX * damage, distanceY * damage, distanceZ * damage));
        }
    }

    public void doExplosionB(boolean spawnParticles) {
        this.world.func_184148_a((EntityPlayer)null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.size >= 2.0f && this.damagesTerrain) {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        }
        if (this.damagesTerrain) {
            for (BlockPos blockPos : this.affectedBlockPositions) {
                IBlockState iblockstate = this.world.func_180495_p(blockPos);
                Block block = iblockstate.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockPos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double d1 = (float)blockPos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double d2 = (float)blockPos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double d3 = d0 - this.x;
                    double d4 = d1 - this.y;
                    double d5 = d2 - this.z;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.size + 0.1);
                    this.world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.x) / 2.0, (d1 + this.y) / 2.0, (d2 + this.z) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    this.world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (this.dropsBlocks && block.func_149659_a(this.explosion)) {
                    block.func_180653_a(this.world, blockPos, this.world.func_180495_p(blockPos), 1.0f / (this.size * this.size / 10.0f), 0);
                }
                block.onBlockExploded(this.world, blockPos, this.explosion);
            }
        }
        if (this.nuclearWaste) {
            for (BlockPos blockPos : this.affectedBlockPositions) {
                if (this.world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a || !this.world.func_180495_p(blockPos.func_177977_b()).func_185913_b() || this.random.nextInt(2) != 0) continue;
                this.world.func_175656_a(blockPos, BlockInit.BLOCK_NUCLEAR_WASTE.func_176223_P());
            }
        }
    }

    public Map<EntityPlayer, Vec3d> getPlayerKnockbackMap() {
        return this.playerKnockbackMap;
    }

    @Nullable
    public EntityLivingBase getExplosivePlacedBy() {
        if (this.exploder == null) {
            return null;
        }
        if (this.exploder instanceof EntityTNTPrimed) {
            return ((EntityTNTPrimed)this.exploder).func_94083_c();
        }
        return this.exploder instanceof EntityLivingBase ? (EntityLivingBase)this.exploder : null;
    }

    public void clearAffectedBlockPositions() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> getAffectedBlockPositions() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

