/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.rank;

import c4.champions.Champions;
import c4.champions.common.config.ConfigHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import org.apache.logging.log4j.Level;

public class Rank {
    private final int tier;
    private final int color;
    private final int affixes;
    private final int growthFactor;
    private final float chance;
    private final String[] potions;

    public Rank() {
        this(0, 0, 0, 0.0f, 0, new String[0]);
    }

    public Rank(int tier, int affixes, int growthFactor, float chance, int color, String[] potions) {
        this.tier = tier;
        this.affixes = affixes;
        this.growthFactor = growthFactor;
        this.chance = chance;
        this.color = color;
        this.potions = potions;
    }

    public int getTier() {
        return this.tier;
    }

    public int getColor() {
        String[] colors = ConfigHandler.client.colors;
        if (colors.length >= this.tier && this.tier > 0) {
            String s = colors[this.tier - 1];
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                Champions.logger.log(Level.ERROR, "Non-integer in color config! " + s);
                return this.color;
            }
        }
        return this.color;
    }

    public int getAffixes() {
        return this.affixes;
    }

    public int getGrowthFactor() {
        return this.growthFactor;
    }

    public float getChance() {
        return this.chance;
    }

    public String[] getPotions() {
        return this.potions;
    }

    public void applyGrowth(EntityLivingBase entityLivingBase) {
        this.applyGrowth(entityLivingBase, SharedMonsterAttributes.field_111267_a, ConfigHandler.growth.health, 2);
        entityLivingBase.func_70606_j(entityLivingBase.func_110138_aP());
        this.applyGrowth(entityLivingBase, SharedMonsterAttributes.field_111264_e, ConfigHandler.growth.attackDamage, 2);
        this.applyGrowth(entityLivingBase, SharedMonsterAttributes.field_188791_g, ConfigHandler.growth.armor, 0);
        this.applyGrowth(entityLivingBase, SharedMonsterAttributes.field_189429_h, ConfigHandler.growth.armorToughness, 0);
        this.applyGrowth(entityLivingBase, SharedMonsterAttributes.field_111266_c, ConfigHandler.growth.knockbackResist, 0);
    }

    private void applyGrowth(EntityLivingBase entityLivingBase, IAttribute attribute, double amount, int operation) {
        IAttributeInstance att = entityLivingBase.func_110148_a(attribute);
        if (att != null) {
            double oldMax = entityLivingBase.func_110148_a(attribute).func_111125_b();
            double newMax = 0.0;
            amount *= (double)this.growthFactor;
            switch (operation) {
                case 0: {
                    newMax = oldMax + amount;
                    break;
                }
                case 1: {
                    newMax = oldMax * amount;
                    break;
                }
                case 2: {
                    newMax = oldMax * (1.0 + amount);
                }
            }
            entityLivingBase.func_110148_a(attribute).func_111128_a(newMax);
        }
    }
}

