/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.mixin.internal;

import java.util.List;
import org.minimallycorrect.javatransformer.api.MethodInfo;
import org.minimallycorrect.javatransformer.api.code.CodeFragment;
import org.minimallycorrect.mixin.Inject;
import org.minimallycorrect.mixin.internal.MixinError;

class Injector {
    Injector() {
    }

    static void inject(MethodInfo target, MethodInfo injectable, Inject inject) {
        CodeFragment.Body targetFragment = target.getCodeFragment();
        CodeFragment.Body injectableFragment = injectable.getCodeFragment();
        if (targetFragment == null || injectableFragment == null) {
            return;
        }
        List fragments = targetFragment.findFragments(inject.type().getFragmentClass());
        String arg = inject.value();
        int index = inject.index();
        int i = 0;
        for (CodeFragment fragment : fragments) {
            if (!"".equals(arg) && fragment instanceof CodeFragment.HasName) {
                if (!((CodeFragment.HasName)fragment).getName().equals(arg)) continue;
                throw new UnsupportedOperationException("Unknown fragment class to match Inject.value into " + fragment.getClass());
            }
            if (index == -1 || index == i) {
                try {
                    fragment.insert((CodeFragment)injectableFragment, inject.position().getPosition());
                }
                catch (Throwable t) {
                    throw new MixinError("Failed to inject " + injectable + " into " + fragment + " in " + target + " with " + inject, t);
                }
            }
            ++i;
        }
    }
}

