/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.network;

import java.util.HashMap;
import java.util.Map;
import mcmultipart.network.ChangeList;
import mcmultipart.network.MultipartAction;
import mcmultipart.network.Packet;
import mcmultipart.network.PacketMultipartAction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Triple;

public class MultipartNetworkHandler {
    public static final SimpleNetworkWrapper wrapper = NetworkRegistry.INSTANCE.newSimpleChannel("mcmultipart");
    private static Map<Triple<Integer, Integer, Integer>, ChangeList> changeList = new HashMap<Triple<Integer, Integer, Integer>, ChangeList>();

    public static void init() {
        wrapper.registerMessage(PacketMultipartAction.class, PacketMultipartAction.class, 3, Side.CLIENT);
    }

    public static void queuePartChange(World world, MultipartAction action) {
        if (world.field_72995_K) {
            return;
        }
        int chunkX = action.pos.func_177958_n() >> 4;
        int chunkZ = action.pos.func_177952_p() >> 4;
        Triple key = Triple.of((Object)chunkX, (Object)chunkZ, (Object)world.field_73011_w.getDimension());
        ChangeList cl = changeList.getOrDefault(key, new ChangeList());
        changeList.put((Triple<Integer, Integer, Integer>)key, cl);
        cl.addChange(action);
    }

    public static void flushChanges() {
        for (Map.Entry<Triple<Integer, Integer, Integer>, ChangeList> list : changeList.entrySet()) {
            MultipartNetworkHandler.flushChanges((Integer)list.getKey().getLeft(), (Integer)list.getKey().getMiddle(), (Integer)list.getKey().getRight(), list.getValue());
        }
        changeList.clear();
    }

    public static void flushChanges(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        int chunkX = pos.func_177958_n() >> 4;
        int chunkY = pos.func_177952_p() >> 4;
        int dim = world.field_73011_w.getDimension();
        Triple key = Triple.of((Object)chunkX, (Object)chunkY, (Object)dim);
        ChangeList cl = changeList.get(key);
        if (cl != null) {
            MultipartNetworkHandler.flushChanges(chunkX, chunkY, dim, cl);
            changeList.remove(key);
        }
    }

    private static void flushChanges(int chunkX, int chunkY, int dim, ChangeList list) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        PlayerChunkMap manager = world.func_184164_w();
        for (EntityPlayer player : world.field_73010_i) {
            if (!manager.func_72694_a((EntityPlayerMP)player, chunkX, chunkY)) continue;
            wrapper.sendTo((IMessage)new PacketMultipartAction(list), (EntityPlayerMP)player);
        }
    }

    public static void sendToServer(Packet<?> message) {
        wrapper.sendToServer(message);
    }
}

