/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.gui.element;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import p455w0rdslib.api.gui.IGuiList;
import p455w0rdslib.api.gui.IGuiListItem;
import p455w0rdslib.api.gui.IGuiScrollbar;
import p455w0rdslib.api.gui.IModularGui;
import p455w0rdslib.client.gui.element.GuiElement;
import p455w0rdslib.client.gui.element.GuiPos;
import p455w0rdslib.client.gui.element.GuiVScrollbar;

public class GuiList
extends GuiElement
implements IGuiList {
    int selectedIndex = 0;
    int firstIndex = 0;
    int borderColor = -13421773;
    int backgroundColor = -13421773;
    int selectedBackgroundColor = -13421773;
    int disabledBackgroundColor = -16777216;
    int textColor = -1;
    int disabledTextColor = -13421773;
    int selectedTextColor = -16711936;
    int highlightColor = 1712848749;
    List<IGuiListItem> listList;
    IGuiScrollbar attachedScrollbar;

    public GuiList(IModularGui guiIn, GuiPos pos, int elementWidth, int elementHeight) {
        this(guiIn, pos, elementWidth, elementHeight, null);
    }

    public GuiList(IModularGui guiIn, GuiPos pos, int elementWidth, int elementHeight, @Nullable List<IGuiListItem> list) {
        super(guiIn, pos, elementWidth, elementHeight);
        if (list != null) {
            this.setList(list);
        }
    }

    @Override
    public int drawListItem(int elementIndex, int x, int y) {
        IGuiListItem element = this.getList().get(elementIndex);
        if (element.getParent() == null) {
            element.setParent(this);
        }
        if (element.isHighlighted()) {
            element.draw(x, y + 4, element.isDisabled() ? this.getDisabledBackgroundColor() : this.getHighlightColor(), element.isDisabled() ? this.getDisabledTextColor() : this.getSelectedTextColor());
        } else if (elementIndex == this.selectedIndex) {
            element.draw(x, y + 4, element.isDisabled() ? this.getDisabledBackgroundColor() : this.getSelectedBackgroundColor(), element.isDisabled() ? this.getDisabledTextColor() : this.getSelectedTextColor());
        } else {
            element.draw(x, y + 4, element.isDisabled() ? this.getDisabledBackgroundColor() : this.getBackgroundColor(), element.isDisabled() ? this.getDisabledTextColor() : this.getTextColor());
        }
        return element.getHeight() + 5;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        Gui.func_73734_a((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth() + 1), (int)(this.getY() + this.getHeight() + 1), (int)this.getBorderColor());
        Gui.func_73734_a((int)(this.getX() + 1), (int)(this.getY() + 1), (int)(this.getX() + this.getWidth()), (int)(this.getY() + this.getHeight()), (int)this.getBackgroundColor());
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int heightDrawn = 0;
        int e = this.size();
        for (int nextElement = this.firstIndex; nextElement < e && heightDrawn + 3 < this.getHeight(); ++nextElement) {
            heightDrawn += this.drawListItem(nextElement, this.getX(), this.getY() + heightDrawn);
        }
    }

    @Override
    public IGuiScrollbar getAttachedScrollbar() {
        return this.attachedScrollbar;
    }

    @Override
    public IGuiList setAttachedScrollbar(IGuiScrollbar scrollbar) {
        this.attachedScrollbar = scrollbar;
        return this;
    }

    @Override
    public IGuiList attachScrollbar(IGuiScrollbar scrollbar) {
        if (this.getAttachedScrollbar() == null) {
            this.setAttachedScrollbar(scrollbar).setVisible(this.isVisible());
            this.getGui().addElement(scrollbar);
        }
        return this;
    }

    @Override
    public IGuiList generateScrollbar() {
        if (this.getAttachedScrollbar() == null) {
            this.attachScrollbar(new GuiVScrollbar(this.getGui(), new GuiPos(this.getX() + this.getWidth() - 6, this.getY() + 1), 6, this.getHeight() - 1, this.getPrevScrollPos()).setParentElement(this));
            this.setWidth(this.getWidth() - 6);
        }
        return this;
    }

    @Override
    public int getHighlightColor() {
        return this.highlightColor;
    }

    @Override
    public IGuiList setHighlightColor(int color) {
        this.highlightColor = color;
        return this;
    }

    @Override
    public int getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    @Override
    public IGuiList setDisabledBackgroundColor(int color) {
        this.disabledBackgroundColor = color;
        return this;
    }

    @Override
    public int getTextColor() {
        return this.textColor;
    }

    @Override
    public IGuiList setTextColor(int color) {
        this.textColor = color;
        return this;
    }

    @Override
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public IGuiList setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    @Override
    public int getSelectedTextColor() {
        return this.selectedTextColor;
    }

    @Override
    public IGuiList setSelectedTextColor(int color) {
        this.selectedTextColor = color;
        return this;
    }

    @Override
    public int getSelectedBackgroundColor() {
        return this.selectedBackgroundColor;
    }

    @Override
    public IGuiList setSelectedBackgroundColor(int color) {
        this.selectedBackgroundColor = color;
        return this;
    }

    @Override
    public int getDisabledTextColor() {
        return this.disabledTextColor;
    }

    @Override
    public IGuiList setDisabledTextColor(int color) {
        this.disabledTextColor = color;
        return this;
    }

    @Override
    public int getBorderColor() {
        return this.borderColor;
    }

    @Override
    public IGuiList setBorderColor(int color) {
        this.borderColor = color;
        return this;
    }

    @Override
    public boolean onClick(int mouseX, int mouseY) {
        int elementHeight;
        int heightChecked = 0;
        for (int i = this.firstIndex; i < this.getList().size() && heightChecked < this.getHeight(); heightChecked += elementHeight + 8, ++i) {
            elementHeight = this.getList().get(i).getHeight();
            if (this.getY() + heightChecked > mouseY + 12 || this.getY() + heightChecked + elementHeight < mouseY || mouseX < this.getX() || mouseX > this.getX() + this.getWidth()) continue;
            if (this.getList().get(i).isDisabled()) break;
            if (GuiScreen.func_146271_m()) {
                this.getList().get(i).setHighlighted(!this.getList().get(i).isHighlighted());
                break;
            }
            this.setSelectedIndex(i);
            break;
        }
        return true;
    }

    @Override
    public boolean isMouseOverElement(IGuiListItem element, int mouseX, int mouseY) {
        return mouseX > element.getX() && mouseX < element.getX() + element.getWidth() && mouseY > element.getY() - 6 && mouseY < element.getY() + element.getHeight() + 6;
    }

    @Override
    public IGuiList setClickedElement(IGuiListItem element) {
        if (!this.isEmpty()) {
            for (int i = 0; i < this.getList().size(); ++i) {
                if (!element.equals(this.getList().get(i))) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public int getPrevScrollPos() {
        int heightUsed;
        int position = this.size() - 1;
        if (position < 0) {
            return 0;
        }
        for (heightUsed = 0; position >= 0 && heightUsed < this.getHeight(); heightUsed += this.getList().get(position--).getHeight()) {
        }
        if (heightUsed > this.getHeight()) {
            ++position;
        }
        return position + 5;
    }

    @Override
    public IGuiList add(IGuiListItem listItem) {
        this.getList().add(listItem);
        return this;
    }

    @Override
    public IGuiList addAll(List<IGuiListItem> list) {
        this.listList.addAll(list);
        return this;
    }

    @Override
    public void remove(IGuiListItem listItem) {
        int itemIndex = this.getList().indexOf(listItem);
        if (this.getList().remove(listItem)) {
            if (itemIndex < this.firstIndex) {
                --this.firstIndex;
            }
            if (itemIndex < this.selectedIndex) {
                --this.selectedIndex;
            }
        }
    }

    @Override
    public void scrollTo(int index) {
        if (index >= 0 && index < this.getList().size()) {
            this.firstIndex = index;
        }
    }

    @Override
    public void scrollDown() {
        int heightDisplayed = 0;
        int elementsDisplayed = 0;
        for (int i = this.firstIndex; i < this.getList().size() && heightDisplayed <= this.getHeight(); ++i) {
            heightDisplayed += this.getList().get(i).getHeight() + 10;
            ++elementsDisplayed;
        }
        if (this.firstIndex + elementsDisplayed < this.getList().size()) {
            ++this.firstIndex;
        }
        this.onScroll(this.firstIndex);
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int direction) {
        if (direction > 0) {
            this.scrollUp();
            if (this.getAttachedScrollbar() != null) {
                this.getAttachedScrollbar().setScrollPos(this.getAttachedScrollbar().getScrollPos() - 2);
            }
        } else if (direction < 0) {
            this.scrollDown();
            if (this.getAttachedScrollbar() != null) {
                this.getAttachedScrollbar().setScrollPos(this.getAttachedScrollbar().getScrollPos() + 2);
            }
        }
        return true;
    }

    public void onScroll(int firstIndexIn) {
    }

    @Override
    public void scrollUp() {
        if (this.firstIndex > 0) {
            --this.firstIndex;
        }
        this.onScroll(this.firstIndex);
    }

    @Override
    public void clear() {
        this.getList().clear();
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public IGuiList setSelectedIndex(int index) {
        if (index == this.selectedIndex) {
            this.selectedIndex = -1;
        } else if (index < this.getList().size()) {
            this.selectedIndex = index;
        }
        return this;
    }

    @Override
    public IGuiListItem getSelectedElement() {
        if (this.selectedIndex == -1 || this.selectedIndex >= this.getList().size()) {
            return null;
        }
        return this.getList().get(this.selectedIndex);
    }

    @Override
    public String getSelectedText() {
        return this.getSelectedElement() == null ? "" : this.getSelectedElement().getDisplayText();
    }

    @Override
    public IGuiList setList(List<IGuiListItem> list) {
        this.listList = list;
        return this;
    }

    @Override
    public List<IGuiListItem> getList() {
        return this.listList;
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    @Override
    public int getTotalListHeight() {
        int totalHeight = 0;
        for (IGuiListItem entry : this.getList()) {
            totalHeight += entry.getHeight() + 2;
        }
        return totalHeight;
    }
}

