/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.handlers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import p455w0rdslib.api.IProcess;

public class ProcessHandlerClient {
    private static List<IProcess> processes = new ArrayList<IProcess>();
    private static List<IProcess> newProcesses = new ArrayList<IProcess>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ProcessHandlerClient());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ArrayList<IProcess> tmpList = new ArrayList<IProcess>(processes);
            Iterator i = tmpList.iterator();
            ArrayList toBeRemoved = Lists.newArrayList();
            while (i.hasNext()) {
                IProcess process = (IProcess)i.next();
                if (process.isDead()) {
                    toBeRemoved.add(process);
                    continue;
                }
                process.updateProcess();
            }
            if (!toBeRemoved.isEmpty()) {
                for (IProcess p : toBeRemoved) {
                    if (!tmpList.contains(p)) continue;
                    tmpList.remove(p);
                }
            }
            if (!newProcesses.isEmpty()) {
                tmpList.addAll(newProcesses);
                newProcesses.clear();
            }
            if (!tmpList.isEmpty()) {
                processes.clear();
                processes.addAll(tmpList);
            }
        }
    }

    @SubscribeEvent
    public void onWorldClose(WorldEvent.Unload event) {
        processes.clear();
        newProcesses.clear();
    }

    public static void addProcess(IProcess process) {
        newProcesses.add(process);
    }
}

