/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class PrototypedIngredientAlternativesList<T, M>
implements IPrototypedIngredientAlternatives<T, M> {
    public static final Serializer SERIALIZER = new Serializer();
    private final List<IPrototypedIngredient<T, M>> alternatives;

    public PrototypedIngredientAlternativesList(List<IPrototypedIngredient<T, M>> alternatives) {
        this.alternatives = alternatives;
    }

    @Override
    public Collection<IPrototypedIngredient<T, M>> getAlternatives() {
        return this.alternatives;
    }

    @Override
    public IPrototypedIngredientAlternatives.ISerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean equals(Object obj) {
        return obj instanceof IPrototypedIngredientAlternatives && this.getAlternatives().equals(((IPrototypedIngredientAlternatives)obj).getAlternatives());
    }

    public int hashCode() {
        int inputsHash = 333;
        for (IPrototypedIngredient<T, M> value : this.getAlternatives()) {
            inputsHash |= value.hashCode();
        }
        return 0x4D3 | inputsHash << 2;
    }

    public String toString() {
        return "[PrototypedIngredientAlternativesList: " + this.alternatives.toString() + "]";
    }

    public static class Serializer
    implements IPrototypedIngredientAlternatives.ISerializer<PrototypedIngredientAlternativesList<?, ?>> {
        @Override
        public byte getId() {
            return 0;
        }

        @Override
        public <T, M> NBTBase serialize(IngredientComponent<T, M> ingredientComponent, PrototypedIngredientAlternativesList<?, ?> alternatives) {
            NBTTagList prototypes = new NBTTagList();
            IIngredientSerializer serializer = ingredientComponent.getSerializer();
            for (IPrototypedIngredient prototypedIngredient : ((PrototypedIngredientAlternativesList)alternatives).alternatives) {
                NBTTagCompound prototypeTag = new NBTTagCompound();
                prototypeTag.func_74782_a("prototype", serializer.serializeInstance(prototypedIngredient.getPrototype()));
                prototypeTag.func_74782_a("condition", serializer.serializeCondition(prototypedIngredient.getCondition()));
                prototypes.func_74742_a((NBTBase)prototypeTag);
            }
            return prototypes;
        }

        @Override
        public <T, M> PrototypedIngredientAlternativesList<?, ?> deserialize(IngredientComponent<T, M> ingredientComponent, NBTBase tag) {
            String componentName = ingredientComponent.getName().toString();
            NBTTagList instancesTag = (NBTTagList)tag;
            ArrayList instances = Lists.newArrayList();
            IIngredientSerializer<T, M> serializer = ingredientComponent.getSerializer();
            for (NBTBase prototypeTag : instancesTag) {
                if (!(prototypeTag instanceof NBTTagCompound)) {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid sublist with NBTTagCompunds");
                }
                NBTTagCompound safePrototypeTag = (NBTTagCompound)prototypeTag;
                if (!safePrototypeTag.func_74764_b("prototype")) {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid sublist with a prototype entry");
                }
                if (!safePrototypeTag.func_74764_b("condition")) {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid sublist with a condition entry");
                }
                instances.add(new PrototypedIngredient<T, M>(ingredientComponent, serializer.deserializeInstance(safePrototypeTag.func_74781_a("prototype")), serializer.deserializeCondition(safePrototypeTag.func_74781_a("condition"))));
            }
            return new PrototypedIngredientAlternativesList(instances);
        }
    }
}

