/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.commoncapabilities.api.capability.fluidhandler.FluidHandlerFluidStackIterator;
import org.cyclops.commoncapabilities.api.capability.fluidhandler.FluidMatch;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;

public class IngredientComponentStorageWrapperHandlerFluidStack
implements IIngredientComponentStorageWrapperHandler<FluidStack, Integer, IFluidHandler> {
    private final IngredientComponent<FluidStack, Integer> ingredientComponent;

    public IngredientComponentStorageWrapperHandlerFluidStack(IngredientComponent<FluidStack, Integer> ingredientComponent) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
    }

    @Override
    public IIngredientComponentStorage<FluidStack, Integer> wrapComponentStorage(IFluidHandler storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    @Override
    public IFluidHandler wrapStorage(IIngredientComponentStorage<FluidStack, Integer> componentStorage) {
        return new FluidStorageWrapper(componentStorage);
    }

    @Override
    @Nullable
    public IFluidHandler getStorage(ICapabilityProvider capabilityProvider, @Nullable EnumFacing facing) {
        return (IFluidHandler)capabilityProvider.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    @Override
    public IngredientComponent<FluidStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    public static class DummyFluidTankProperties
    implements IFluidTankProperties {
        private final FluidStack fluidStack;

        public DummyFluidTankProperties(FluidStack fluidStack) {
            this.fluidStack = fluidStack;
        }

        @Nullable
        public FluidStack getContents() {
            return this.fluidStack;
        }

        public int getCapacity() {
            return Integer.MAX_VALUE;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }
    }

    public static class FluidStorageWrapper
    implements IFluidHandler {
        private final IIngredientComponentStorage<FluidStack, Integer> storage;

        public FluidStorageWrapper(IIngredientComponentStorage<FluidStack, Integer> storage) {
            this.storage = storage;
        }

        public IFluidTankProperties[] getTankProperties() {
            return (IFluidTankProperties[])Lists.newArrayList(this.storage).stream().map(DummyFluidTankProperties::new).toArray(IFluidTankProperties[]::new);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            FluidStack inserted = this.storage.insert(resource, !doFill);
            return inserted == null ? resource.amount : resource.amount - inserted.amount;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            FluidStack extractSimulated = this.storage.extract(resource, 3, true);
            if (extractSimulated != null) {
                FluidStack prototype = resource;
                if (prototype.amount > extractSimulated.amount) {
                    prototype = prototype.copy();
                    prototype.amount = extractSimulated.amount;
                }
                return this.storage.extract(prototype, 7, !doDrain);
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.storage.extract(maxDrain, !doDrain);
        }
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorage<FluidStack, Integer> {
        private final IngredientComponent<FluidStack, Integer> ingredientComponent;
        private final IFluidHandler storage;

        public ComponentStorageWrapper(IngredientComponent<FluidStack, Integer> ingredientComponent, IFluidHandler storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public IngredientComponent<FluidStack, Integer> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<FluidStack> iterator() {
            return new FluidHandlerFluidStackIterator(this.storage);
        }

        @Override
        public Iterator<FluidStack> iterator(@Nonnull FluidStack prototype, Integer matchFlags) {
            if (this.getComponent().getMatcher().getAnyMatchCondition().equals(matchFlags)) {
                return this.iterator();
            }
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), (Object)prototype, (Object)matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            long sum = 0L;
            for (IFluidTankProperties properties : this.storage.getTankProperties()) {
                sum = Math.addExact(sum, (long)properties.getCapacity());
            }
            return sum;
        }

        @Override
        public FluidStack insert(@Nonnull FluidStack ingredient, boolean simulate) {
            if (ingredient == null) {
                return null;
            }
            int totalAmount = ingredient.amount;
            int filledAmount = this.storage.fill(ingredient, !simulate);
            if (filledAmount >= totalAmount) {
                return null;
            }
            int remaining = totalAmount - filledAmount;
            return new FluidStack(ingredient, remaining);
        }

        @Override
        public FluidStack extract(@Nonnull FluidStack prototype, Integer matchFlags, boolean simulate) {
            if (prototype == null) {
                return null;
            }
            if (matchFlags == 0) {
                return this.storage.drain(FluidHelpers.getAmount((FluidStack)prototype), !simulate);
            }
            if (matchFlags == 4) {
                FluidStack drainedSimulated = this.storage.drain(prototype.amount, false);
                if (drainedSimulated == null || drainedSimulated.amount != prototype.amount) {
                    return null;
                }
                return simulate ? drainedSimulated : this.storage.drain(prototype.amount, true);
            }
            for (IFluidTankProperties properties : this.storage.getTankProperties()) {
                if (properties.getContents() == null || !FluidMatch.areFluidStacksEqual(properties.getContents(), prototype, matchFlags & 0xFFFFFFFB)) continue;
                FluidStack toDrain = properties.getContents();
                toDrain = toDrain.copy();
                toDrain.amount = prototype.amount;
                FluidStack drained = this.storage.drain(toDrain, !simulate);
                if (!FluidMatch.areFluidStacksEqual(drained, prototype, matchFlags)) continue;
                return drained;
            }
            return null;
        }

        @Override
        public FluidStack extract(long maxQuantity, boolean simulate) {
            return this.storage.drain(Helpers.castSafe((long)maxQuantity), !simulate);
        }
    }
}

