/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.net;

import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.FastenerType;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessor;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.net.FLMessage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class MessageConnection<C extends Connection>
extends FLMessage {
    public BlockPos pos;
    public FastenerAccessor accessor;
    public UUID uuid;

    public MessageConnection() {
    }

    public MessageConnection(C connection) {
        Fastener<?> fastener = ((Connection)connection).getFastener();
        this.pos = fastener.getPos();
        this.accessor = fastener.createAccessor();
        this.uuid = ((Connection)connection).getUUID();
    }

    protected abstract boolean isInstanceOfType(Class<? extends Connection> var1);

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_150786_a(FastenerType.serialize(this.accessor));
        buf.func_179252_a(this.uuid);
    }

    @Override
    public void deserialize(PacketBuffer buf) throws IOException {
        this.pos = buf.func_179259_c();
        this.accessor = FastenerType.deserialize(buf.func_150793_b());
        this.uuid = buf.func_179253_g();
    }

    @Override
    public final void process(MessageContext ctx) {
        Fastener<?> fastener;
        Connection connection;
        World world = this.getWorld(ctx);
        this.accessor.update(world, this.pos);
        if (this.accessor.isLoaded(world) && (connection = (fastener = this.accessor.get(world)).getConnections().get(this.uuid)) != null && this.isInstanceOfType(connection.getClass())) {
            this.process(ctx, connection);
        }
    }

    protected abstract World getWorld(MessageContext var1);

    protected abstract void process(MessageContext var1, C var2);
}

