/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.crafting.ingredient;

import com.google.common.collect.Multimap;
import com.pau101.fairylights.util.Utils;
import com.pau101.fairylights.util.crafting.GenericRecipe;
import com.pau101.fairylights.util.crafting.ingredient.Ingredient;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public interface IngredientAuxiliary<A>
extends Ingredient<IngredientAuxiliary<?>, GenericRecipe.MatchResultAuxiliary> {
    public boolean isRequired();

    public int getLimit();

    @Nullable
    public A accumulator();

    public void consume(A var1, ItemStack var2);

    public boolean finish(A var1, ItemStack var2);

    default public boolean process(Multimap<IngredientAuxiliary<?>, GenericRecipe.MatchResultAuxiliary> map, ItemStack output) {
        Collection results = map.get((Object)this);
        if (results.isEmpty() && this.isRequired()) {
            return true;
        }
        A ax = this.accumulator();
        for (GenericRecipe.MatchResultAuxiliary result : results) {
            this.consume(ax, result.getInput());
        }
        return this.finish(ax, output);
    }

    @Override
    default public void addTooltip(List<String> tooltip) {
        if (!this.isRequired()) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.ingredient.auxiliary.optional"));
        }
    }
}

