/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.paint.render.PaintedBlockAccessWrapper;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.model.CollectedQuadBakedBlockModel;
import crazypants.enderio.base.render.pipeline.CacheKey;
import crazypants.enderio.base.render.pipeline.OverlayHolder;
import crazypants.enderio.base.render.pipeline.PaintWrangler;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.util.Profiler;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class BlockStateWrapperBase
extends CacheKey
implements IBlockStateWrapper {
    private static final Cache<Pair<Block, Long>, QuadCollector> cache = CacheBuilder.newBuilder().maximumSize(500L).build();
    @Nonnull
    protected final Block block;
    @Nonnull
    protected final IBlockState state;
    @Nonnull
    protected final IBlockAccess world;
    @Nonnull
    protected final BlockPos pos;
    @Nonnull
    protected final IRenderMapper.IBlockRenderMapper renderMapper;
    protected boolean doCaching = false;
    protected IBakedModel model = null;
    @Nonnull
    private final YetaUtil.YetaDisplayMode yetaDisplayMode = YetaUtil.getYetaDisplayMode();
    private static final BlockRenderLayer BREAKING = null;
    @Nonnull
    private static final IRenderMapper.IBlockRenderMapper nullRenderMapper = new IRenderMapper.IBlockRenderMapper(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
            return null;
        }
    };

    public BlockStateWrapperBase(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, IRenderMapper.IBlockRenderMapper renderMapper) {
        this.state = state;
        this.block = state.func_177230_c();
        this.world = world;
        this.pos = pos;
        this.renderMapper = renderMapper != null ? renderMapper : nullRenderMapper;
    }

    protected BlockStateWrapperBase(@Nonnull BlockStateWrapperBase parent, @Nonnull IBlockState state) {
        this.block = parent.block;
        this.state = state;
        this.world = parent.world;
        this.pos = parent.pos;
        this.renderMapper = parent.renderMapper;
        this.doCaching = parent.doCaching;
        this.model = parent.model;
    }

    protected void putIntoCache(@Nonnull QuadCollector quads) {
        cache.put((Object)Pair.of((Object)this.block, (Object)this.getCacheKey()), (Object)quads);
    }

    protected QuadCollector getFromCache() {
        return (QuadCollector)cache.getIfPresent((Object)Pair.of((Object)this.block, (Object)this.getCacheKey()));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void invalidate(@Nonnull ModelBakeEvent event) {
        cache.invalidateAll();
    }

    @Nonnull
    public <T extends Comparable<T>> T func_177229_b(@Nonnull IProperty<T> property) {
        return (T)this.state.func_177229_b(property);
    }

    @Nonnull
    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(@Nonnull IProperty<T> property, @Nonnull V value) {
        return new BlockStateWrapperBase(this, this.state.func_177226_a(property, value));
    }

    @Nonnull
    public <T extends Comparable<T>> IBlockState func_177231_a(@Nonnull IProperty<T> property) {
        return new BlockStateWrapperBase(this, this.state.func_177231_a(property));
    }

    @Nonnull
    public ImmutableMap<IProperty<?>, Comparable<?>> func_177228_b() {
        return this.state.func_177228_b();
    }

    @Nonnull
    public Block func_177230_c() {
        return this.block;
    }

    @Override
    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        if (this.world instanceof ChunkCache) {
            return ((ChunkCache)this.world).func_190300_a(this.pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return this.world.func_175625_s(this.pos);
    }

    @Override
    @Nonnull
    public IBlockAccess getWorld() {
        return this.world;
    }

    @Override
    @Nonnull
    public IBlockState getState() {
        return this.state;
    }

    @Override
    @Nonnull
    public IBlockStateWrapper addCacheKey(@Nullable Object addlCacheKey) {
        super.addCacheKey(addlCacheKey);
        this.doCaching = !(this.world instanceof PaintedBlockAccessWrapper);
        return this;
    }

    @Override
    public void bakeModel() {
        String cacheResult;
        boolean fromCache;
        long start = Profiler.instance.start();
        QuadCollector quads = null;
        QuadCollector overlayQuads = null;
        QuadCollector paintQuads = new QuadCollector();
        boolean hasPaintRendered = false;
        if (!(!(this.block instanceof IPaintable.IBlockPaintableBlock) || this.block instanceof IPaintable.IWrenchHideablePaint && this.getYetaDisplayMode().isHideFacades())) {
            hasPaintRendered = PaintWrangler.wrangleBakedModel(this.world, this.pos, ((IPaintable.IBlockPaintableBlock)this.block).getPaintSource(this.state, this.world, this.pos), paintQuads);
        }
        boolean bl = fromCache = this.doCaching && MinecraftForgeClient.getRenderLayer() != null;
        if (!hasPaintRendered || this.renderMapper instanceof IRenderMapper.IBlockRenderMapper.IRenderLayerAware.IPaintAware) {
            cacheResult = fromCache ? ((quads = this.getFromCache()) == null ? "miss" : "hit") : "not cachable";
            if (quads == null) {
                quads = new QuadCollector();
                this.bakeBlockLayer(quads);
                if (fromCache) {
                    this.putIntoCache(quads);
                }
            }
        } else {
            cacheResult = "paint only";
        }
        overlayQuads = OverlayHolder.getOverlay(this.renderMapper.mapOverlayLayer(this, this.world, this.pos, hasPaintRendered));
        this.model = new CollectedQuadBakedBlockModel(paintQuads.combine(overlayQuads).combine(quads));
        Profiler.instance.stop(start, this.state.func_177230_c().func_149732_F() + " (bake, cache=" + cacheResult + ")");
    }

    protected void bakeBlockLayer(QuadCollector quads) {
        if (this.renderMapper == nullRenderMapper) {
            IBakedModel missingModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            for (BlockRenderLayer layer : quads.getBlockLayers()) {
                quads.addUnfriendlybakedModel(layer, missingModel, this.state, 0L);
            }
        } else if (this.renderMapper instanceof IRenderMapper.IBlockRenderMapper.IRenderLayerAware) {
            for (BlockRenderLayer layer : quads.getBlockLayers()) {
                quads.addFriendlyBlockStates(layer, this.renderMapper.mapBlockRender(this, this.world, this.pos, layer, quads));
            }
        } else {
            BlockRenderLayer layer = this.block.func_180664_k();
            quads.addFriendlyBlockStates(layer, this.renderMapper.mapBlockRender(this, this.world, this.pos, layer, quads));
            quads.addFriendlyBlockStates(BREAKING, this.renderMapper.mapBlockRender(this, this.world, this.pos, BREAKING, quads));
        }
    }

    public IBakedModel getModel() {
        if (this.model == null) {
            this.bakeModel();
            if (this.model != null) {
                Log.warn(this.block + " doesn't bake its model!");
            } else {
                Log.warn(this.block + "'s model won't bake!");
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
        }
        return this.model;
    }

    @Override
    @Nonnull
    public YetaUtil.YetaDisplayMode getYetaDisplayMode() {
        return this.yetaDisplayMode;
    }

    @Nonnull
    public Material func_185904_a() {
        return this.state.func_185904_a();
    }

    public boolean func_185913_b() {
        return this.state.func_185913_b();
    }

    public int func_185891_c() {
        return this.state.func_185891_c();
    }

    public int getLightOpacity(@Nonnull IBlockAccess world1, @Nonnull BlockPos pos1) {
        return this.state.getLightOpacity(world1, pos1);
    }

    public int func_185906_d() {
        return this.state.func_185906_d();
    }

    public int getLightValue(@Nonnull IBlockAccess world1, @Nonnull BlockPos pos1) {
        return this.state.getLightValue(world1, pos1);
    }

    public boolean func_185895_e() {
        return this.state.func_185895_e();
    }

    public boolean func_185916_f() {
        return this.state.func_185916_f();
    }

    @Nonnull
    public MapColor func_185909_g(@Nonnull IBlockAccess p_185909_1_, @Nonnull BlockPos p_185909_2_) {
        return this.state.func_185909_g(p_185909_1_, p_185909_2_);
    }

    @Nonnull
    public IBlockState func_185907_a(@Nonnull Rotation rot) {
        return this.state.func_185907_a(rot);
    }

    @Nonnull
    public IBlockState func_185902_a(@Nonnull Mirror mirrorIn) {
        return this.state.func_185902_a(mirrorIn);
    }

    public boolean func_185917_h() {
        return this.state.func_185917_h();
    }

    @Nonnull
    public EnumBlockRenderType func_185901_i() {
        return this.state.func_185901_i();
    }

    public int func_185889_a(@Nonnull IBlockAccess source, @Nonnull BlockPos pos1) {
        return this.state.func_185889_a(source, pos1);
    }

    public float func_185892_j() {
        return this.state.func_185892_j();
    }

    public boolean func_185898_k() {
        return this.state.func_185898_k();
    }

    public boolean func_185915_l() {
        return this.state.func_185915_l();
    }

    public boolean func_185897_m() {
        return this.state.func_185897_m();
    }

    public int func_185911_a(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos1, @Nonnull EnumFacing side) {
        return this.state.func_185911_a(blockAccess, pos1, side);
    }

    public boolean func_185912_n() {
        return this.state.func_185912_n();
    }

    public int func_185888_a(@Nonnull World worldIn, @Nonnull BlockPos pos1) {
        return this.state.func_185888_a(worldIn, pos1);
    }

    public float func_185887_b(@Nonnull World worldIn, @Nonnull BlockPos pos1) {
        return this.state.func_185887_b(worldIn, pos1);
    }

    public float func_185903_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos1) {
        return this.state.func_185903_a(player, worldIn, pos1);
    }

    public int func_185893_b(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos1, @Nonnull EnumFacing side) {
        return this.state.func_185893_b(blockAccess, pos1, side);
    }

    @Nonnull
    public EnumPushReaction func_185905_o() {
        return this.state.func_185905_o();
    }

    @Nonnull
    public IBlockState func_185899_b(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos1) {
        return this.state.func_185899_b(blockAccess, pos1);
    }

    public boolean func_185894_c(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos1, @Nonnull EnumFacing facing) {
        return this.state.func_185894_c(blockAccess, pos1, facing);
    }

    public boolean func_185914_p() {
        return this.state.func_185914_p();
    }

    @Nonnull
    public AxisAlignedBB func_185918_c(@Nonnull World worldIn, @Nonnull BlockPos pos1) {
        return this.state.func_185918_c(worldIn, pos1);
    }

    @Nonnull
    public AxisAlignedBB func_185900_c(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos1) {
        return this.state.func_185900_c(blockAccess, pos1);
    }

    @Nonnull
    public RayTraceResult func_185910_a(@Nonnull World worldIn, @Nonnull BlockPos pos1, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.state.func_185910_a(worldIn, pos1, start, end);
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockAccess world1, @Nonnull BlockPos pos1, @Nonnull EnumFacing side) {
        return this.state.doesSideBlockRendering(world1, pos1, side);
    }

    public boolean isSideSolid(@Nonnull IBlockAccess world1, @Nonnull BlockPos pos1, @Nonnull EnumFacing side) {
        return this.state.isSideSolid(world1, pos1, side);
    }

    public boolean func_189547_a(@Nonnull World worldIn, @Nonnull BlockPos pos1, int id, int param) {
        return this.state.func_189547_a(worldIn, pos1, id, param);
    }

    @Nonnull
    public Collection<IProperty<?>> func_177227_a() {
        return this.state.func_177227_a();
    }

    public void func_189546_a(@Nonnull World worldIn, @Nonnull BlockPos pos1, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        this.state.func_189546_a(worldIn, pos1, blockIn, fromPos);
    }

    public boolean func_189884_a(@Nonnull Entity entityIn) {
        return this.state.func_189884_a(entityIn);
    }

    public boolean func_191057_i() {
        return this.state.func_191057_i();
    }

    @Nullable
    public AxisAlignedBB func_185890_d(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos1) {
        return this.state.func_185890_d(worldIn, pos1);
    }

    public void func_185908_a(@Nonnull World worldIn, @Nonnull BlockPos pos1, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185908_6_) {
        this.state.func_185908_a(worldIn, pos1, entityBox, collidingBoxes, entityIn, p_185908_6_);
    }

    @Nonnull
    public Vec3d func_191059_e(@Nonnull IBlockAccess access, @Nonnull BlockPos pos1) {
        return this.state.func_191059_e(access, pos1);
    }

    public boolean func_191058_s() {
        return this.state.func_191058_s();
    }

    public boolean func_185896_q() {
        return this.state.func_185896_q();
    }

    @Nonnull
    public BlockFaceShape func_193401_d(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos1, @Nonnull EnumFacing facing) {
        return this.state.func_193401_d(worldIn, pos1, facing);
    }

    public boolean doesSideBlockChestOpening(@Nonnull IBlockAccess world1, @Nonnull BlockPos pos1, @Nonnull EnumFacing side) {
        return this.state.doesSideBlockChestOpening(world1, pos1, side);
    }
}

