/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.property;

import com.enderio.core.common.util.NNList;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import crazypants.enderio.base.render.property.IOMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PropertyIO
extends PropertyHelper<IOMode> {
    @Nonnull
    private static final ImmutableSet<IOMode> allowedValues;
    @Nonnull
    private static final Map<String, IOMode> nameToValue;
    @Nonnull
    private static final PropertyIO instance;

    protected PropertyIO(String name) {
        super(name, IOMode.class);
    }

    @Nonnull
    public static PropertyIO getInstance() {
        return instance;
    }

    @Nonnull
    public Collection<IOMode> func_177700_c() {
        return allowedValues;
    }

    @Nonnull
    public String getName(@Nonnull IOMode value) {
        return value.toString();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Optional<IOMode> func_185929_b(@Nonnull String value) {
        return Optional.fromNullable((Object)nameToValue.get(value));
    }

    static {
        nameToValue = Maps.newHashMap();
        ArrayList<IOMode> values = new ArrayList<IOMode>();
        for (EnumFacing facing : NNList.FACING) {
            NNList.NNIterator iomodes = IOMode.EnumIOMode.IOMODES.iterator();
            while (iomodes.hasNext()) {
                IOMode value = IOMode.get(facing, (IOMode.EnumIOMode)((Object)iomodes.next()));
                values.add(value);
                nameToValue.put(value.toString(), value);
            }
        }
        allowedValues = ImmutableSet.copyOf(values);
        instance = new PropertyIO("iomode");
    }
}

