/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.util;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import java.util.AbstractList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class HalfBakedQuad {
    @Nonnull
    private final NNList<Vertex> corners;
    @Nonnull
    private final TextureAtlasSprite tex;
    @Nonnull
    private final Vector4f color;
    @Nonnull
    private final EnumFacing face;
    @Nonnull
    private static final Vector4f NO_COLOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static boolean hasMojangFixedUVXWTextureCoords = false;

    public HalfBakedQuad(@Nonnull BoundingBox bb, @Nonnull EnumFacing face, float umin, float umax, float vmin, float vmax, @Nullable TextureAtlasSprite tex, @Nullable Vector4f color) {
        this.corners = bb.getCornersWithUvForFace(face, umin, umax, vmin, vmax);
        this.tex = tex != null ? tex : Minecraft.func_71410_x().func_147117_R().func_174944_f();
        this.color = color != null ? color : NO_COLOR;
        this.face = face;
    }

    public void bake(@Nonnull List<BakedQuad> quads) {
        float w01 = 1.0f;
        float w23 = 1.0f;
        if (hasMojangFixedUVXWTextureCoords && this.face != EnumFacing.DOWN && this.face != EnumFacing.UP) {
            w01 = (float)((Vertex)this.corners.get((int)0)).xyz.distance(((Vertex)this.corners.get((int)1)).xyz);
            w23 = (float)((Vertex)this.corners.get((int)2)).xyz.distance(((Vertex)this.corners.get((int)3)).xyz);
        }
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        builder.setQuadOrientation(this.face);
        builder.setTexture(this.tex);
        this.putVertexData(builder, (Vertex)this.corners.get(0), w01);
        this.putVertexData(builder, (Vertex)this.corners.get(1), w01);
        this.putVertexData(builder, (Vertex)this.corners.get(2), w23);
        this.putVertexData(builder, (Vertex)this.corners.get(3), w23);
        quads.add((BakedQuad)builder.build());
    }

    private void putVertexData(@Nonnull UnpackedBakedQuad.Builder builder, @Nonnull Vertex v, float w) {
        VertexFormat format = builder.getVertexFormat();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)v.x(), (float)v.y(), (float)v.z(), 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float d = LightUtil.diffuseLight((float)v.nx(), (float)v.ny(), (float)v.nz());
                    builder.put(e, new float[]{d * this.color.x, d * this.color.y, d * this.color.z, this.color.w});
                    continue block6;
                }
                case UV: {
                    builder.put(e, new float[]{this.tex.func_94214_a((double)(v.u() * 16.0f)) * w, this.tex.func_94207_b((double)(v.v() * 16.0f)) * w, 0.0f, w});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{v.nx(), v.ny(), v.nz(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public void recomputeNormals() {
        Vector3d T1 = new Vector3d();
        Vector3d T2 = new Vector3d();
        Vector3d T3 = new Vector3d();
        T1.set(((Vertex)this.corners.get((int)1)).xyz);
        T1.sub(((Vertex)this.corners.get((int)0)).xyz);
        T2.set(((Vertex)this.corners.get((int)2)).xyz);
        T2.sub(((Vertex)this.corners.get((int)0)).xyz);
        T3.cross(T1, T2);
        T3.normalize();
        for (Vertex vertex : this.corners) {
            vertex.setNormal(T3.x, T3.y, T3.z);
        }
    }

    public void transform(final VertexTransform ... xforms) {
        this.corners.apply((NNList.Callback)new NNList.Callback<Vertex>(){

            public void apply(@Nonnull Vertex vertex) {
                for (VertexTransform xform : xforms) {
                    xform.apply(vertex);
                }
            }
        });
        this.recomputeNormals();
    }

    public void render(@Nonnull BufferBuilder tes) {
        for (Vertex v : this.corners) {
            tes.func_181662_b(v.x(), v.y(), v.z()).func_187315_a((double)this.tex.func_94214_a((double)(v.u() * 16.0f)), (double)this.tex.func_94207_b((double)(v.v() * 16.0f))).func_181666_a(this.color.x, this.color.y, this.color.z, this.color.w).func_181663_c(v.nx(), v.ny(), v.nz()).func_181675_d();
        }
    }

    public static class HalfBakedList
    extends AbstractList<HalfBakedQuad> {
        @Nonnull
        private final NNList<HalfBakedQuad> store = new NNList();

        @Override
        @Nonnull
        public HalfBakedQuad get(int index) {
            return (HalfBakedQuad)this.store.get(index);
        }

        @Override
        public int size() {
            return this.store.size();
        }

        public void add(@Nonnull BoundingBox bb, @Nonnull EnumFacing face, float umin, float umax, float vmin, float vmax, TextureAtlasSprite tex, Vector4f color) {
            this.store.add((Object)new HalfBakedQuad(bb, face, umin, umax, vmin, vmax, tex, color));
        }

        public void add(@Nonnull BoundingBox bb, @Nonnull EnumFacing face, double umin, double umax, double vmin, double vmax, TextureAtlasSprite tex, Vector4f color) {
            this.store.add((Object)new HalfBakedQuad(bb, face, (float)umin, (float)umax, (float)vmin, (float)vmax, tex, color));
        }

        public void add(@Nonnull BoundingBox bb, @Nonnull EnumFacing face, float umin, float umax, float vmin, float vmax, TextureAtlasSprite tex, Vector4f color, boolean upsidedown) {
            if (upsidedown) {
                this.store.add((Object)new HalfBakedQuad(bb, face, umin, umax, vmax, vmin, tex, color));
            } else {
                this.store.add((Object)new HalfBakedQuad(bb, face, umin, umax, vmin, vmax, tex, color));
            }
        }

        public void add(@Nonnull BoundingBox bb, @Nonnull EnumFacing face, double umin, double umax, double vmin, double vmax, TextureAtlasSprite tex, Vector4f color, boolean upsidedown) {
            if (upsidedown) {
                this.store.add((Object)new HalfBakedQuad(bb, face, (float)umin, (float)umax, (float)vmax, (float)vmin, tex, color));
            } else {
                this.store.add((Object)new HalfBakedQuad(bb, face, (float)umin, (float)umax, (float)vmin, (float)vmax, tex, color));
            }
        }

        public void transform(VertexTransform ... xforms) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.transform(xforms);
            }
        }

        public void bake(@Nonnull List<BakedQuad> quads, VertexTransform ... xforms) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.transform(xforms);
                halfBakedQuad.bake(quads);
            }
        }

        public void bake(@Nonnull List<BakedQuad> quads) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.bake(quads);
            }
        }

        public void render(@Nonnull BufferBuilder tes) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.render(tes);
            }
        }

        public void render() {
            RenderUtil.bindBlockTexture();
            RenderHelper.func_74518_a();
            BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
            for (int i = 0; i <= 1; ++i) {
                if (i == 0) {
                    GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
                } else {
                    GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                }
                tes.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                this.render(tes);
                Tessellator.func_178181_a().func_78381_a();
            }
            RenderHelper.func_74519_b();
        }
    }
}

