/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1;

import com.infinityraider.agricraft.api.v1.AgriApiState;
import com.infinityraider.agricraft.api.v1.IAgriApiConnector;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.misc.IAgriPeripheralMethod;
import com.infinityraider.agricraft.api.v1.misc.IAgriRegistry;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutationEngine;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoilRegistry;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatCalculator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public final class AgriApi {
    public static final String MOD_ID = "agricraft";
    public static final String API_ID = "agricraft-api-v1";
    private static final IAgriApiConnector CONNECTOR = AgriApi.connect();

    @Nonnull
    AgriApiState getState() {
        return CONNECTOR.getState();
    }

    @Nonnull
    public static IAgriRegistry<IAgriPlant> getPlantRegistry() {
        return CONNECTOR.connectPlantRegistry();
    }

    @Nonnull
    public static IAgriMutationRegistry getMutationRegistry() {
        return CONNECTOR.connectMutationRegistry();
    }

    @Nonnull
    public static IAgriSoilRegistry getSoilRegistry() {
        return CONNECTOR.connectSoilRegistry();
    }

    @Nonnull
    public static IAgriAdapterizer<IAgriStat> getStatRegistry() {
        return CONNECTOR.connectStatRegistry();
    }

    @Nonnull
    public static IAgriAdapterizer<IAgriStatCalculator> getStatCalculatorRegistry() {
        return CONNECTOR.connectStatCalculatorRegistry();
    }

    @Nonnull
    public static IAgriMutationEngine getMutationEngine() {
        return CONNECTOR.connectMutationEngine();
    }

    @Nonnull
    public static IAgriAdapterizer<AgriSeed> getSeedRegistry() {
        return CONNECTOR.connectSeedRegistry();
    }

    @Nonnull
    public static IAgriAdapterizer<IAgriFertilizer> getFertilizerRegistry() {
        return CONNECTOR.connectFertilizerRegistry();
    }

    @Nonnull
    public static IAgriRegistry<IAgriPeripheralMethod> getPeripheralMethodRegistry() {
        return CONNECTOR.connectPeripheralMethodRegistry();
    }

    @Nonnull
    private static IAgriApiConnector connect() {
        IAgriApiConnector instance;
        Constructor<IAgriApiConnector> constructor;
        Class<IAgriApiConnector> clazz;
        try {
            clazz = Class.forName("com.infinityraider.agricraft.impl.v1.AgriApiConnector").asSubclass(IAgriApiConnector.class);
        }
        catch (ClassNotFoundException exception) {
            FMLLog.log((String)API_ID, (Level)Level.INFO, (String)"The AgriCraft APIv1 was unable find AgriCraft! Is AgriCraft missing from your modpack?", (Object[])new Object[0]);
            return IAgriApiConnector.FAKE;
        }
        catch (ClassCastException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, but instead found an invalid class! This is a serious error that should never happen! Report this error immediately!", exception);
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, found a connection class, but couldn't find a valid no-args constructor! This is a serious error that should never happen! Report this error immediately!", exception);
        }
        catch (SecurityException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, but instead ran into a security exception! This is a very unusual error that should not have happened! Report this error immediately!", exception);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, but instead was prevented from accessing the constructor required to create a connection! This is a very unusual error that should not have happened! Report this error immediately!", exception);
        }
        catch (IllegalArgumentException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, but instead discovered something is wrong with the JVM! This error should never occur! Report this error immediately to Oracle!", exception);
        }
        catch (InstantiationException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, found a connection class, but it was abstract! This is a serious error that should never happen! Report this error immediately!", exception);
        }
        catch (InvocationTargetException exception) {
            throw new RuntimeException("The AgriCraft APIv1 attempted to connect to AgriCraft, found a valid connection class, started instantiation, but then the AgriApi.connector threw an error! This is a serious error that should never happen! Report this error immediately!", exception);
        }
        FMLLog.log((String)API_ID, (Level)Level.INFO, (String)"The AgriCraft APIv1 successfully connected to AgriCraft! Thank you for including AgriCraft in your modpack!", (Object[])new Object[0]);
        return instance;
    }

    private AgriApi() {
    }
}

