/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="agricraft")
public final class GrassDropHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void interceptGrassDrop(BlockEvent.HarvestDropsEvent event) {
        if (event.isSilkTouching()) {
            return;
        }
        IBlockState state = event.getState();
        if (state == null || state.func_177230_c() == null) {
            return;
        }
        Random rand = event.getWorld().field_73012_v;
        if (state.func_177230_c() instanceof BlockTallGrass) {
            if (AgriCraftConfig.wipeGrassDrops) {
                event.getDrops().clear();
            }
            GrassDropHandler.addGrassDrops(event.getDrops(), rand);
        }
    }

    public static void addGrassDrops(List<ItemStack> drops, Random rand) {
        AgriApi.getPlantRegistry().all().stream().forEach(p -> GrassDropHandler.addGrassDrop(drops, rand, p));
    }

    public static void addGrassDrop(List<ItemStack> drops, Random rand, IAgriPlant plant) {
        if (plant.getGrassDropChance() > rand.nextDouble()) {
            drops.add(plant.getSeed());
        }
    }
}

